/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995-2007 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: P_PrintTool.C,v $
 *	$Author: johns $	$Locker:  $		$State: Exp $
 *	$Revision: 1.6 $	$Date: 2007/01/12 20:08:28 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *  Very simple tool that prints tracker position and orientation data
 *
 ***************************************************************************/

#include "P_PrintTool.h"
#include "utilities.h"
#include "Matrix4.h"
#include "Inform.h"

PrintTool::PrintTool(int id, VMDApp *vmdapp, Displayable *disp) 
: Tool(id, vmdapp, disp) {
  targetting=0;
}

void PrintTool::do_event() {
  float p[3];
  Matrix4 o;

  if(!position()) return;
  vec_copy(p, position());
  o = *orientation();

  msgInfo << "Tool[" << id() << "] pos: " 
          << p[0] << ", " << p[1] << ", " << p[2] << sendmsg;  
}

