/***************************************************************************
 *cr
 *cr            (C) Copyright 1995-2007 The Board of Trustees of the
 *cr                        University of Illinois
 *cr                         All Rights Reserved
 *cr
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *      $RCSfile: GraphicsFltkReps.h,v $
 *      $Author: johns $        $Locker:  $             $State: Exp $
 *      $Revision: 1.63 $       $Date: 2007/01/18 20:21:38 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *  generated by Fast Light User Interface Designer (fluid) version 1.0011
 ***************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include "FL/forms.H"
#include "FL/Fl_Counter.H"
#include "FL/Fl_Value_Slider.H"
#include "FL/Fl_Float_Input.H"
#include "FL/Fl_Tabs.H"
#include "AtomRep.h"

/// GUI controls for each draw style, creates rep commands
/// for CmdMolChangeRepItem or CmdMolRep, and sets its valuators 
/// correctly given an AtomRep.
class GraphicsFltkRep : public Fl_Group {
protected:
  GraphicsFltkRep()
  : Fl_Group(10, 380, 295, 160) {}
  virtual void do_reset() {}

  char cmdbuf[256];

public:
  virtual int is_volumetric() { return 0; }
  virtual const char *repcmd() = 0;
  virtual void set_values(AtomRep *) = 0;
  void reset() { do_reset(); }
};


#define CTRWIDTH 120
#define CTRHEIGHT 25
/// counter control used set radii       
class RadiusCounter : public Fl_Counter {
public:
  RadiusCounter(int x, int y, const char *nm)
  : Fl_Counter(x, y, CTRWIDTH, CTRHEIGHT, nm) {
    minimum(0);
    precision(1);
    step(.1);
    lstep(1);
    align(FL_ALIGN_LEFT);
    when(FL_WHEN_RELEASE);
  }
};


/// counter control used to set tessellation resolution
class ResolutionCounter : public Fl_Counter {
public:
  ResolutionCounter(int x, int y, const char *nm)
  : Fl_Counter(x, y, CTRWIDTH, CTRHEIGHT, nm) {
    minimum(1);
    precision(0);
    step(1);
    lstep(5);
    align(FL_ALIGN_LEFT);
    when(FL_WHEN_RELEASE);
  }
};

/// counter control used to set volume extraction step size
class StepCounter : public Fl_Counter {
public:
  StepCounter(int x, int y, const char *nm)
  : Fl_Counter(x, y, 90, CTRHEIGHT, nm) {
    minimum(1);
    precision(0);
    step(1);
    lstep(4);
    align(FL_ALIGN_LEFT);
    when(FL_WHEN_RELEASE);
  }
};


/// chooser control used to select from a list of representation settings
class RepChoice : public Fl_Choice {
public:
  RepChoice(int x, int y, const char *nm)  
  : Fl_Choice(x, y, CTRWIDTH, CTRHEIGHT, nm) {
    color(FL_PALEGREEN);
    selection_color(FL_BLACK);
    align(FL_ALIGN_LEFT);
  }
  int setvalue(int newvalue) {
    if (newvalue >= 0 && newvalue < size())
      return Fl_Choice::value(newvalue);
    return value();
  }
};


/// slider control with text entry box, used to select isovalues, etc
class IsoSlider : public Fl_Value_Slider {
public:
  IsoSlider(int x, int y, const char *nm)
  : Fl_Value_Slider(x, y, CTRWIDTH+90, CTRHEIGHT, nm) {
    color(FL_WHITE);
    align(FL_ALIGN_LEFT);
    type(FL_HOR_SLIDER);
  }
};


/// 'Lines' representation controls
class GraphicsFltkRepLines : public GraphicsFltkRep {
public:
  GraphicsFltkRepLines(Fl_Callback *cb, void *v) {
    thickness = new ResolutionCounter(x()+170, y()+120, "Thickness");
    thickness->callback(cb, v);
    Fl_Group::end();
  }
  const char *repcmd() {
    sprintf(cmdbuf, "Lines %f", thickness->value());
    return cmdbuf;
  }
  void set_values(AtomRep *rep) {
    thickness->value(rep->get_data(AtomRep::LINETHICKNESS));
  }
 
protected:
  void do_reset() {
    thickness->value(1);
  }

private:
  Fl_Counter *thickness;
};


/// 'Bonds' representation controls
class GraphicsFltkRepBonds : public GraphicsFltkRep {
public:
  GraphicsFltkRepBonds(Fl_Callback *cb, void *v) {
    radius = new RadiusCounter(x()+170, y()+90, "Bond Radius");
    resolution= new ResolutionCounter(x()+170,y()+120,"Bond Resolution");
    radius->callback(cb, v);
    resolution->callback(cb, v);
    Fl_Group::end();
  }
  const char *repcmd() {
    sprintf(cmdbuf, "Bonds %f %f", radius->value(), resolution->value());
    return cmdbuf;
  }
  void set_values(AtomRep *rep) {
    radius->value(rep->get_data(AtomRep::BONDRAD));
    resolution->value(rep->get_data(AtomRep::BONDRES));
  }

protected:
  void do_reset() {
    radius->value(0.3);
    resolution->value(6);
  }

protected:
  Fl_Counter *radius;
  Fl_Counter *resolution;
};


/// 'DynamicBonds' representation controls
class GraphicsFltkRepDynamicBonds : public GraphicsFltkRep {
private:
  Fl_Counter *distance;
  Fl_Counter *radius;
  Fl_Counter *resolution;
public:
  GraphicsFltkRepDynamicBonds(Fl_Callback *cb, void *v) {
    distance = new RadiusCounter(x()+170,y()+60,"Distance Cutoff");
    distance->callback(cb, v);
    radius = new RadiusCounter(x()+170, y()+90, "Bond Radius");
    radius->callback(cb, v);
    resolution= new ResolutionCounter(x()+170,y()+120,"Bond Resolution");
    resolution->callback(cb, v);
    Fl_Group::end();
  }
protected:
  void do_reset() {
    distance->value(1.6);
    radius->value(0.3);
    resolution->value(6);
  }
public:
  const char *repcmd() {
    sprintf(cmdbuf, "DynamicBonds %f %f %f", distance->value(), radius->value(),
      resolution->value());
    return cmdbuf;
  }
  void set_values(AtomRep *rep) {
    distance->value(rep->get_data(AtomRep::SPHERERAD));
    radius->value(rep->get_data(AtomRep::BONDRAD));
    resolution->value(rep->get_data(AtomRep::BONDRES));
  }
};

 
/// 'CPK' representation controls
class GraphicsFltkRepCPK : public GraphicsFltkRep {
public:
  GraphicsFltkRepCPK(Fl_Callback *cb, void *v) {
    bradius = new RadiusCounter(x()+170,y()+90,"Bond Radius");
    bresolution= new ResolutionCounter(x()+170,y()+120,"Bond Resolution");
    bradius->callback(cb, v);
    bresolution->callback(cb, v);

    sradius = new RadiusCounter(x()+170,y()+30,"Sphere Scale");
    sresolution= new ResolutionCounter(x()+170,y()+60,"Sphere Resolution");
    sradius->callback(cb, v);
    sresolution->callback(cb, v);

    Fl_Group::end();
  }

  const char *repcmd() {
    sprintf(cmdbuf, "CPK %f %f %f %f", sradius->value(), bradius->value(),
        sresolution->value(), bresolution->value());
    return cmdbuf;
  }
  void set_values(AtomRep *rep) {
    bradius->value(rep->get_data(AtomRep::BONDRAD));
    bresolution->value(rep->get_data(AtomRep::BONDRES));
    sradius->value(rep->get_data(AtomRep::SPHERERAD));
    sresolution->value(rep->get_data(AtomRep::SPHERERES));
  }

protected:
  void do_reset() {
    bradius->value(0.3);
    bresolution->value(6);
    sradius->value(1.0);
    sresolution->value(8);
  }

private:
  Fl_Counter *bradius;
  Fl_Counter *bresolution;
  Fl_Counter *sradius;
  Fl_Counter *sresolution;
};


/// 'Points' representation controls
class GraphicsFltkRepPoints : public GraphicsFltkRep {
public:
  GraphicsFltkRepPoints(Fl_Callback *cb, void *v) {
    size = new ResolutionCounter(x()+170, y()+120, "Size");
    size->callback(cb, v);
    Fl_Group::end();
  }
  const char *repcmd() {
    sprintf(cmdbuf, "Points %f", size->value());
    return cmdbuf;
  }
  void set_values(AtomRep *rep) {
    size->value(rep->get_data(AtomRep::LINETHICKNESS));
  }

protected:
  void do_reset() {
    size->value(1);
  }

private:
  Fl_Counter *size;
};


 
/// 'VDW' representation controls
class GraphicsFltkRepVDW : public GraphicsFltkRep {
public:
  GraphicsFltkRepVDW(Fl_Callback *cb, void *v) {
    radius = new RadiusCounter(x()+170,y()+90,"Sphere Scale");
    resolution= new ResolutionCounter(x()+170,y()+120,"Sphere Resolution");
    radius->callback(cb, v);
    resolution->callback(cb, v);
    Fl_Group::end();
  }

  const char *repcmd() {
    sprintf(cmdbuf, "VDW %f %f", radius->value(), resolution->value());
    return cmdbuf;
  }
  void set_values(AtomRep *rep) {
    radius->value(rep->get_data(AtomRep::SPHERERAD));
    resolution->value(rep->get_data(AtomRep::SPHERERES));
  }

protected:
  void do_reset() {
    radius->value(1.0);
    resolution->value(8);
  }

protected:
  Fl_Counter *radius;
  Fl_Counter *resolution;
};


/// 'Beads' representation controls
class GraphicsFltkRepBeads : public GraphicsFltkRepVDW {
public:
  GraphicsFltkRepBeads(Fl_Callback *cb, void *v)
  : GraphicsFltkRepVDW(cb, v) {}
  const char *repcmd() {
    sprintf(cmdbuf, "Beads %f %f", radius->value(), resolution->value()); 
    return cmdbuf;
  }
};


/// 'Dotted' representation controls
class GraphicsFltkRepDotted : public GraphicsFltkRepVDW {
public:
  GraphicsFltkRepDotted(Fl_Callback *cb, void *v)
  : GraphicsFltkRepVDW(cb, v) {}
  const char *repcmd() {
    sprintf(cmdbuf, "Dotted %f %f", radius->value(), resolution->value()); 
    return cmdbuf;
  }
};


/// 'Trace' representation controls
class GraphicsFltkRepTrace : public GraphicsFltkRepBonds {
public:
  GraphicsFltkRepTrace(Fl_Callback *cb, void *v)
  : GraphicsFltkRepBonds(cb, v) {}
  const char *repcmd() {
    sprintf(cmdbuf, "Trace %f %f", radius->value(), resolution->value());
    return cmdbuf;
  }
};


/// 'Licorice' representation controls
class GraphicsFltkRepLicorice : public GraphicsFltkRepBonds {
private:
  Fl_Counter *sresolution;
public:
  GraphicsFltkRepLicorice(Fl_Callback *cb, void *v)
  :  GraphicsFltkRepBonds(cb, v) {
    Fl_Group::begin();
    sresolution= new ResolutionCounter(x()+170,y()+60,"Sphere Resolution");
    sresolution->callback(cb, v);

    Fl_Group::end();
  }
protected:
  void do_reset() {
    GraphicsFltkRepBonds::do_reset();
    resolution->value(10);
    sresolution->value(10);
  }
public:
  const char *repcmd() {
    sprintf(cmdbuf, "Licorice %f %f %f", radius->value(), sresolution->value(),
      resolution->value());
    return cmdbuf;
  }
  void set_values(AtomRep *rep) {
    GraphicsFltkRepBonds::set_values(rep);
    sresolution->value(rep->get_data(AtomRep::SPHERERES));
  }
};
    

/// 'Tube' representation controls
class GraphicsFltkRepTube : public GraphicsFltkRepBonds {
public:
  GraphicsFltkRepTube(Fl_Callback *cb, void *v)
  : GraphicsFltkRepBonds(cb, v) {
    radius->label("Radius");
    resolution->label("Resolution");
  }
  const char *repcmd() {
    sprintf(cmdbuf, "Tube %f %f", radius->value(), resolution->value());
    return cmdbuf;
  }
};
    

/// 'Ribbons' representation controls
class GraphicsFltkRepRibbons : public GraphicsFltkRepBonds {
protected:
  Fl_Counter *thickness;
public:
  GraphicsFltkRepRibbons(Fl_Callback *cb, void *v)
  : GraphicsFltkRepBonds(cb, v) {
    radius->label("Radius"); 
    resolution->label("Resolution");
    Fl_Group::begin();
    thickness = new ResolutionCounter(x()+170,y()+60,"Width");
    thickness->callback(cb, v);
    Fl_Group::end();
  }
protected:
  void do_reset() {
    GraphicsFltkRepBonds::do_reset();
    thickness->value(2);
  }
public:
  const char *repcmd() {
    sprintf(cmdbuf, "Ribbons %f %f %f", radius->value(), resolution->value(),
      thickness->value());
    return cmdbuf;
  }
  void set_values(AtomRep *rep) {
    GraphicsFltkRepBonds::set_values(rep);
    thickness->value(rep->get_data(AtomRep::LINETHICKNESS));
  }
};


/// 'NewRibbons' representation controls
class GraphicsFltkRepNewRibbons : public GraphicsFltkRep {
private:
  RepChoice *basis;
  IsoSlider *thickness, *ratio;
  ResolutionCounter *resolution;
public:
  GraphicsFltkRepNewRibbons(Fl_Callback *cb, void *v) {

    Fl_Group::begin();
    thickness = new IsoSlider(x()+80, y()+90, "Thickness");
    thickness->callback(cb, v);
    thickness->minimum(0.1);
    thickness->maximum(10.0);

    resolution= new ResolutionCounter(x()+170,y()+120,"Resolution");
    resolution->callback(cb, v);
    resolution->maximum(50.0);

    ratio= new IsoSlider(x()+80, y()+60, "Aspect Ratio");
    ratio->callback(cb, v);
    ratio->minimum(1.0);
    ratio->maximum(10.0);

    basis = new RepChoice(x()+170,y()+30,"Spline Style");
    basis->add("Catmull-Rom");
    basis->add("B-Spline");
    basis->callback(cb, v);
    Fl_Group::end();
  }
protected:
  void do_reset() {
    thickness->value(0.3);
    resolution->value(6);
    ratio->value(3);
    basis->value(0);
  }
public:
  const char *repcmd() {
    sprintf(cmdbuf, "NewRibbons %f %f %f %d", thickness->value(), 
        resolution->value(), ratio->value(), basis->value());
    return cmdbuf;
  }
  void set_values(AtomRep *rep) {
    ratio->value(rep->get_data(AtomRep::LINETHICKNESS));
    basis->value((int)rep->get_data(AtomRep::SPHERERAD));
    thickness->value(rep->get_data(AtomRep::BONDRAD));
    resolution->value(rep->get_data(AtomRep::BONDRES));
  }
};


/// 'Cartoon' representation controls
class GraphicsFltkRepCartoon : public GraphicsFltkRepRibbons {
public:
  GraphicsFltkRepCartoon(Fl_Callback *cb, void *v)
  : GraphicsFltkRepRibbons(cb, v) {
    radius->label("Helix/Coil Radius");
    resolution->label("Helix/Coil Resolution");
    thickness->label("Beta Sheet Thickness");
  }
  const char *repcmd() {
    sprintf(cmdbuf, "Cartoon %f %f %f", radius->value(), resolution->value(),
      thickness->value());
    return cmdbuf;
  }
protected:
  void do_reset() {
    radius->value(2.1);
    resolution->value(12.0);
    thickness->value(5.0);
  }
};


/// 'NewCartoon' representation controls
class GraphicsFltkRepNewCartoon : public GraphicsFltkRep {
private:
  RepChoice *basis;
  IsoSlider *thickness, *ratio;
  ResolutionCounter *resolution;
public:
  GraphicsFltkRepNewCartoon(Fl_Callback *cb, void *v) {

    Fl_Group::begin();
    thickness = new IsoSlider(x()+80, y()+90, "Thickness");
    thickness->callback(cb, v);
    thickness->minimum(0.1);
    thickness->maximum(10.0);

    resolution= new ResolutionCounter(x()+170,y()+120,"Resolution");
    resolution->callback(cb, v);
    resolution->maximum(50.0);

    ratio= new IsoSlider(x()+80, y()+60, "Aspect Ratio");
    ratio->callback(cb, v);
    ratio->minimum(1.0);
    ratio->maximum(10.0);

    basis = new RepChoice(x()+170,y()+30,"Spline Style");
    basis->add("Catmull-Rom");
    basis->add("B-Spline");
    basis->callback(cb, v);
    Fl_Group::end();
  }
protected:
  void do_reset() {
    thickness->value(0.3);
    resolution->value(6);
    ratio->value(4.1);
    basis->value(0);
  }
public:
  const char *repcmd() {
    sprintf(cmdbuf, "NewCartoon %f %f %f %d", thickness->value(), 
        resolution->value(), ratio->value(), basis->value());
    return cmdbuf;
  }
  void set_values(AtomRep *rep) {
    ratio->value(rep->get_data(AtomRep::LINETHICKNESS));
    basis->value((int)rep->get_data(AtomRep::SPHERERAD));
    thickness->value(rep->get_data(AtomRep::BONDRAD));
    resolution->value(rep->get_data(AtomRep::BONDRES));
  }
};

#ifdef VMDWITHCARBS

/// 'PaperChain' representation controls
class GraphicsFltkRepPaperChain : public GraphicsFltkRep {
private:
  IsoSlider *thickness; 
public:
  GraphicsFltkRepPaperChain(Fl_Callback *cb, void *v) {

    Fl_Group::begin();
    thickness = new IsoSlider(x()+80, y()+90, "Thickness");
    thickness->callback(cb, v);
    thickness->minimum(0.1);
    thickness->maximum(10.0);
    Fl_Group::end();
  }
protected:
  void do_reset() {
    thickness->value(1.0);
  }
public:
  const char *repcmd() {
    sprintf(cmdbuf, "PaperChain %f", thickness->value());
    return cmdbuf;
  }
  void set_values(AtomRep *rep) {
    thickness->value(rep->get_data(AtomRep::LINETHICKNESS));
  }
};

/// 'Twister' representation controls
class GraphicsFltkRepTwister : public GraphicsFltkRep {
private:
  IsoSlider *thickness;
public:
  GraphicsFltkRepTwister(Fl_Callback *cb, void *v) {

    Fl_Group::begin();
    thickness = new IsoSlider(x()+80, y()+90, "Thickness");
    thickness->callback(cb, v);
    thickness->minimum(0.1);
    thickness->maximum(10.0);
    Fl_Group::end();
  }
protected:
  void do_reset() {
    thickness->value(0.5);
  }
public:
  const char *repcmd() {
    sprintf(cmdbuf, "Twister %f", thickness->value());
    return cmdbuf;
  }
  void set_values(AtomRep *rep) {
    thickness->value(rep->get_data(AtomRep::LINETHICKNESS));
  }
};

#endif

/// 'Solvent' representation controls
class GraphicsFltkRepSolvent : public GraphicsFltkRep {
private:
  RepChoice *method;
  Fl_Counter *detail;
  Fl_Counter *probe; 
public:
  GraphicsFltkRepSolvent(Fl_Callback *cb, void *v) {
    method = new RepChoice(x()+170,y()+60,"Representation Method");
    method->add("Points");
    method->add("Crosses");
    method->add("Mesh");
    detail = new ResolutionCounter(x()+170,y()+90,"Detail Level");
    detail->maximum(13);
    probe = new RadiusCounter(x()+170,y()+120,"Probe Radius");
    method->callback(cb, v);
    detail->callback(cb, v);
    probe->callback(cb, v);
    Fl_Group::end();
  }
protected:
  void do_reset() {
    method->value(0);
    detail->value(7.0);
    probe->value(0);
  }
public:
  const char *repcmd() {
    sprintf(cmdbuf, "Solvent %f %f %f", probe->value(), detail->value(),
      (float)(method->value()+1));
    return cmdbuf;
  }
  void set_values(AtomRep *rep) {
    method->setvalue((int)rep->get_data(AtomRep::LINETHICKNESS)-1);
    detail->value(rep->get_data(AtomRep::SPHERERES));
    probe->value(rep->get_data(AtomRep::SPHERERAD));
  }
};
 

/// 'MSMS' representation controls
class GraphicsFltkRepMSMS : public GraphicsFltkRep {
private:
  Fl_Counter *density;
  Fl_Counter *probe;
  RepChoice *method;
  RepChoice *whichatoms;
public:
  GraphicsFltkRepMSMS(Fl_Callback *cb, void *v) {
    density = new RadiusCounter(x()+170,y()+90,"Sample Density");
    density->minimum(0.1);
    density->maximum(30.0);
    density->callback(cb, v);
    probe = new RadiusCounter(x()+170,y()+120, "Probe Radius");
    probe->minimum(0.1);
    probe->maximum(8.0);
    probe->callback(cb, v);
    method = new RepChoice(x()+170,y()+60,"Representation Method");
    method->add("Solid Surface");
    method->add("Wireframe");
    method->callback(cb, v);
    whichatoms = new RepChoice(x()+170,y()+30, "Which Atoms");
    whichatoms->add("Selected");
    whichatoms->add("All");
    whichatoms->callback(cb, v);
    Fl_Group::end();
  }
protected:
  void do_reset() {
    density->value(1.5);
    probe->value(1.5);
    method->value(0);
    whichatoms->value(0);
  }
public:
  const char *repcmd() {
    sprintf(cmdbuf, "MSMS %f %f %f %f", probe->value(), density->value(),
      (float)whichatoms->value(), (float)method->value());
    return cmdbuf;
  }
  void set_values(AtomRep *rep) {
    density->value(rep->get_data(AtomRep::SPHERERES));
    probe->value(rep->get_data(AtomRep::SPHERERAD));
    method->setvalue((int)rep->get_data(AtomRep::BONDRES));
    whichatoms->setvalue((int)rep->get_data(AtomRep::LINETHICKNESS));
  }
};
  

/// 'HBonds' representation controls
class GraphicsFltkRepHBonds : public GraphicsFltkRep {
private:
  Fl_Counter *distance;
  Fl_Counter *angle;
  Fl_Counter *thickness;
public:
  GraphicsFltkRepHBonds(Fl_Callback *cb, void *v) {
    distance = new RadiusCounter(x()+170,y()+60,"Distance Cutoff");
    distance->callback(cb, v);
    angle = new RadiusCounter(x()+170,y()+90,"Angle Cutoff");
    angle->precision(0);
    angle->step(1);
    angle->lstep(10);
    angle->callback(cb, v);
    thickness = new ResolutionCounter(x()+170,y()+120, "Line Thickness");
    thickness->callback(cb, v);
    Fl_Group::end();
  }
protected:
  void do_reset() {
    distance->value(3.0);
    angle->value(20.0);
    thickness->value(1.0);
  }
public:
  const char *repcmd() {
    sprintf(cmdbuf, "HBonds %f %f %f", distance->value(), angle->value(),
      thickness->value());
    return cmdbuf;
  }
  void set_values(AtomRep *rep) {
    distance->value(rep->get_data(AtomRep::BONDRAD));
    angle->value(rep->get_data(AtomRep::SPHERERAD));
    thickness->value(rep->get_data(AtomRep::LINETHICKNESS));
  }
};
     

/// 'Surf' representation controls
class GraphicsFltkRepSurf : public GraphicsFltkRep {
private:
  Fl_Counter *probe;
  RepChoice *method;
public:
  GraphicsFltkRepSurf(Fl_Callback *cb, void *v) {
    probe = new RadiusCounter(x()+170,y()+120,"Probe Radius");
    probe->minimum(0.1);
    probe->callback(cb, v);
    method = new RepChoice(x()+170,y()+90, "Representation Method");
    method->add("Solid Surface");
    method->add("Wireframe");
    method->callback(cb, v);
    Fl_Group::end();
  }
protected:
  void do_reset() {
    probe->value(1.4);
    method->value(0);
  }
public:
  const char *repcmd() {
    sprintf(cmdbuf, "Surf %f %f", probe->value(), (float)method->value());
    return cmdbuf;
  }
  void set_values(AtomRep *rep) {
    probe->value(rep->get_data(AtomRep::SPHERERAD));
    method->setvalue((int)rep->get_data(AtomRep::BONDRES));
  }
};
 

/// Base class for reps that use volumetric data
/// XXX We can't get the information we need from AtomRep to fill in the 
/// data set names or their min/max ranges.  Thus we have to add methods
/// for GraphicsFltkMenu to tell us what this information is.
class GraphicsFltkRepVolumetric: public GraphicsFltkRep {
protected:
  RepChoice *dataset;

  /// volumetric rep internal class for managing min/max values
  struct minmax {
    double minval, maxval;
    minmax(double themin=0, double themax=0) : minval(themin), maxval(themax) {}
    int operator==(const minmax &v) {
      return (minval == v.minval && maxval == v.maxval);
    }
  };
  ResizeArray<minmax> minmaxlist;

  GraphicsFltkRepVolumetric(Fl_Callback *cb, void *v) {
    dataset = new RepChoice(x()+170, y()+30, "Vol");
    dataset->callback(cb, v);
  }
  virtual void do_dataset_clear() {}
  virtual void do_dataset_append(const char *, double, double) {}

public:
  int is_volumetric() { return 1; }
  void dataset_clear() {
    dataset->clear();
    dataset->deactivate();
    minmaxlist.clear();
    do_dataset_clear();
  }
  void dataset_append(const char *nm, double newmin, double newmax) {
    // Fltk doesn't allow adding a menu item with the same name as
    // an existing item, so we use replace, which also avoids 
    // problems with the escape characters interpreted by add()
    int ind = dataset->add("foobar"); 
    char *datalabel = new char[strlen(nm)+32];
    sprintf(datalabel, "vol%d: %s", ind, nm);
    dataset->replace(ind, datalabel);
    delete[] datalabel;
    
    minmaxlist.append(minmax(newmin, newmax));
    dataset->value(minmaxlist.num()-1);
    do_dataset_append(nm, newmin, newmax);
    dataset->activate();
  }
};
  
        
/// 'Isosurface' representation controls
class GraphicsFltkRepIsosurface : public GraphicsFltkRepVolumetric {
private:
  Fl_Slider *isovalue;
  Fl_Float_Input *isoinput;
  Fl_Float_Input *isomininput, *isomaxinput;
  Fl_Counter *resolution;
  Fl_Counter *thickness;
  RepChoice *method;
  RepChoice *boundary;
  Fl_Callback *parentcb;
  void *parentdata;
  int gridstepsize;

  static void datasetchanged_cb(Fl_Widget *w, void *v) {
    GraphicsFltkRepIsosurface *self = (GraphicsFltkRepIsosurface *)v;
    minmax &m = self->minmaxlist[self->dataset->value()];
    self->isovalue->range(m.minval, m.maxval);

    (self->parentcb)(w, self->parentdata);
  }

  static void inputcb(Fl_Widget *, void *v) {
    GraphicsFltkRepIsosurface *self = (GraphicsFltkRepIsosurface *)v;
    char *endptr = NULL;
    const char *strval = self->isoinput->value();
    double val = strtod(strval, &endptr);
    if (endptr != strval) {
      // valid conversion performed
      self->isovalue->value(val);
      (self->parentcb)(self->isovalue, self->parentdata);
    }
  }
  
  static void minmaxinputcb(Fl_Widget *, void *v) {
    GraphicsFltkRepIsosurface *self = (GraphicsFltkRepIsosurface *)v;
    // parse values in input fields
    char *endptr = NULL;
    const char *minstrval = self->isomininput->value();
    double minval = strtod(minstrval, &endptr);
    if (endptr == minstrval) return; // invalid
    const char *maxstrval = self->isomaxinput->value();
    double maxval = strtod(maxstrval, &endptr);
    if (endptr == maxstrval) return; // invalid

    // fields are valid; update cached minmax
    minmax &m = self->minmaxlist[self->dataset->value()];
    m.minval = minval;
    m.maxval = maxval;

    // update the slider itself.  If we made the value change, trigger
    // appropriate callbacks.
    self->isovalue->range(minval, maxval);
    if (self->isovalue->value() < minval) {
      self->isovalue->value(minval);
      slidercb(NULL, v);
    } else if (self->isovalue->value() > maxval) {
      self->isovalue->value(maxval);
      slidercb(NULL, v);
    } else {
      self->setInputFromSlider();
    }
  }

  void setInputFromSlider() {
    char buf[128];
    sprintf(buf, "%8g", (float)isovalue->value()); ///< XXX use snprintf
    isoinput->value(buf);
    sprintf(buf, "%8g", (float)isovalue->minimum());
    isomininput->value(buf);
    sprintf(buf, "%8g", (float)isovalue->maximum());
    isomaxinput->value(buf);
  }

  static void slidercb(Fl_Widget *, void *v) {
    GraphicsFltkRepIsosurface *self = (GraphicsFltkRepIsosurface *)v;
    self->setInputFromSlider();
    (self->parentcb)(self->isovalue, self->parentdata);
  }

protected:
  void do_dataset_clear() { 
    isovalue->deactivate();
    isoinput->deactivate();
    boundary->deactivate();
    method->deactivate();
    resolution->deactivate();
    thickness->deactivate();
  }
  void do_dataset_append(const char *, double min, double max) { 
    isovalue->activate();
    isoinput->activate();
    boundary->activate();
    method->activate();
    resolution->activate();
    thickness->activate();
    isovalue->range(min,max);
    setInputFromSlider();
  }
  void do_reset() {
    set_grid_stepsize(1); ///< full resolution by default
    resolution->value(1); ///< full resolution by default
    thickness->value(1);  ///< 1 pixel by default
    method->value(2);     ///< use the points method by default
    boundary->value(2);   ///< draw box and isosurface by default
    dataset->value(0);    ///< First volume dataset by default
  }

public:
  GraphicsFltkRepIsosurface(Fl_Callback *cb, void *v)
  : GraphicsFltkRepVolumetric(datasetchanged_cb, this) {
    parentcb = cb;
    parentdata = v;

    resolution= new StepCounter(x()+35,y()+90, "Step");
    resolution->callback(cb, v);
    thickness= new StepCounter(x()+35,y()+120, "Size");
    thickness->callback(cb, v);
    method = new RepChoice(x()+170,y()+90,"Draw");
    method->add("Solid Surface");
    method->add("Wireframe");
    method->add("Points");
    method->add("Shaded Points");
    method->callback(cb, v);
    boundary = new RepChoice(x()+170, y()+120, "Show");
    boundary->add("Isosurface");
    boundary->add("Box");
    boundary->add("Box+Isosurface");
    boundary->callback(cb, v); 
    isovalue = new Fl_Slider(x()+150,y()+60, 140, CTRHEIGHT, "");
    isovalue->type(FL_HOR_SLIDER);
    isovalue->color(FL_WHITE);
    isovalue->when(FL_WHEN_CHANGED);
    isovalue->callback(slidercb, this); 
    isoinput = new Fl_Float_Input(x()+80, y()+60, 70, CTRHEIGHT, "Isovalue");
    isoinput->when(FL_WHEN_ENTER_KEY);
    isoinput->selection_color(FL_YELLOW);
    isoinput->callback(inputcb, this);
    isovalue->when(FL_WHEN_CHANGED | FL_WHEN_RELEASE_ALWAYS);

    isomininput = new Fl_Float_Input(x()+45, y()+30, 45, CTRHEIGHT, "Range");
    isomininput->when(FL_WHEN_ENTER_KEY);
    isomininput->selection_color(FL_YELLOW);
    isomininput->callback(minmaxinputcb, this);
    isomaxinput = new Fl_Float_Input(x()+90, y()+30, 45, CTRHEIGHT);
    isomaxinput->when(FL_WHEN_ENTER_KEY);
    isomaxinput->selection_color(FL_YELLOW);
    isomaxinput->callback(minmaxinputcb, this);

    Fl_Group::end();
  }
  const char *repcmd() {
    if (dataset->size() > 0) {
      sprintf(cmdbuf, "Isosurface %f %f %f %f %d %d", 
              (float) isovalue->value(), 
              (float) dataset->value(), 
              (float) boundary->value(), 
              (float) method->value(), 
              gridstepsize + (int) resolution->value() - 1,
              (int) thickness->value());
    } else {
      sprintf(cmdbuf, "Isosurface");
    }
    return cmdbuf;
  }
  void set_values(AtomRep *rep) {
    dataset->setvalue((int)rep->get_data(AtomRep::SPHERERES));
    // minmax needs to update whenever dataset is changed or 
    // the selected rep is switched
    minmax &m = minmaxlist[dataset->value()]; 
    isovalue->range(m.minval, m.maxval);
    isovalue->value(rep->get_data(AtomRep::SPHERERAD));
    method->setvalue((int)rep->get_data(AtomRep::BONDRES));
    boundary->setvalue((int)rep->get_data(AtomRep::LINETHICKNESS));
    resolution->value(rep->get_data(AtomRep::ISOSTEPSIZE) - gridstepsize + 1);
    thickness->value(rep->get_data(AtomRep::ISOLINETHICKNESS));
    setInputFromSlider();
  }
  void set_grid_stepsize(int step) {
    gridstepsize = step;
  }
};
 

/// 'VolumeSlice' representation controls
class GraphicsFltkRepVolumeSlice : public GraphicsFltkRepVolumetric {
private:
  Fl_Value_Slider *slice;
  RepChoice *axis;
  RepChoice *quality;  // texture filtering mode

protected:
  void do_dataset_clear() {
    slice->deactivate();
    axis->deactivate();
    quality->deactivate();
  }
  void do_dataset_append(const char *, double, double) {
    slice->activate();
    axis->activate();
    quality->activate();
  }
  void do_reset() {
    slice->value(0.5);
    axis->value(0);
    quality->value(2);
  }
public:
  GraphicsFltkRepVolumeSlice(Fl_Callback *cb, void *v)
  : GraphicsFltkRepVolumetric(cb, v) {
    slice = new IsoSlider(x()+80, y()+60, "Slice Offset");
    slice->callback(cb, v);
    axis = new RepChoice(x()+170, y()+90, "Slice Axis");
    axis->add("X");
    axis->add("Y");
    axis->add("Z");
    axis->callback(cb, v);
    quality = new RepChoice(x()+170,y()+120, "Render Quality");
    quality->add("Low");
    quality->add("Medium");
    quality->add("High");
    quality->callback(cb, v);
    Fl_Group::end();
  }
  const char *repcmd() {
    if (dataset->size() > 0) {
      sprintf(cmdbuf, "VolumeSlice %f %f %f %f", slice->value(),
        (float)dataset->value(), (float)axis->value(), 
        (float)quality->value()); 
    } else {
      sprintf(cmdbuf, "VolumeSlice");
    }
    return cmdbuf;
  }
  void set_values(AtomRep *rep) {
    dataset->setvalue((int)rep->get_data(AtomRep::SPHERERES));
    slice->value(rep->get_data(AtomRep::SPHERERAD));
    axis->setvalue((int)rep->get_data(AtomRep::LINETHICKNESS)); 
    quality->setvalue((int)rep->get_data(AtomRep::BONDRES));
  }
};


#ifdef VMDFIELDLINES

/// 'FieldLines' representation controls
class GraphicsFltkRepFieldLines : public GraphicsFltkRepVolumetric {
private:
  Fl_Counter *thickness;
  Fl_Value_Slider *gradmag;
  Fl_Value_Slider *minlen;
  Fl_Value_Slider *maxlen;

protected:
  void do_dataset_clear() {
    gradmag->deactivate();
    minlen->deactivate();
    maxlen->deactivate();
    thickness->deactivate();
  }
  void do_dataset_append(const char *, double, double) {
    gradmag->activate();
    minlen->activate();
    maxlen->activate();
    thickness->activate();
  }
  void do_reset() {
    gradmag->value(1.8);
    minlen->value(10);
    maxlen->value(50);
    thickness->value(1);
  }

public:
  GraphicsFltkRepFieldLines(Fl_Callback *cb, void *v)
  : GraphicsFltkRepVolumetric(cb, v) {
    thickness = new ResolutionCounter(x()+20, y()+30, "Size");
    thickness->callback(cb, v);
    gradmag = new IsoSlider(x()+80,  y()+60, "GradientMag");
    gradmag->callback(cb, v);
    minlen = new IsoSlider(x()+80,  y()+90, "Min Length");
    minlen->callback(cb, v);
    maxlen = new IsoSlider(x()+80, y()+120, "Max Length");
    maxlen->callback(cb, v);
    Fl_Group::end();
  }
  const char *repcmd() {
    if (dataset->size() > 0) {
      sprintf(cmdbuf, "FieldLines %f %f %f %f %f", 
        (float)dataset->value(), gradmag->value(), minlen->value(), maxlen->value(), thickness->value());
    } else {
      sprintf(cmdbuf, "FieldLines");
    }
    return cmdbuf;
  }
  void set_values(AtomRep *rep) {
    dataset->setvalue((int)rep->get_data(AtomRep::SPHERERES));
    gradmag->range(0.05, 25.0);
    gradmag->value(rep->get_data(AtomRep::SPHERERAD));
    minlen->range(1, 500.0);
    minlen->value(rep->get_data(AtomRep::BONDRAD));
    maxlen->range(1, 500.0);
    maxlen->value(rep->get_data(AtomRep::BONDRES));
    thickness->range(1, 10);
    thickness->value(rep->get_data(AtomRep::LINETHICKNESS));
  }
};

#endif

