/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995-2007 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: DrawRingsUtils.h,v $
 *	$Author: johns $	$Locker:  $		$State: Exp $
 *	$Revision: 1.3 $	$Date: 2007/01/12 20:08:22 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 * Ulities for calculating ring axes, ring puckering and displacement of
 * atoms from the mean ring plane.
 *
 ***************************************************************************/

#ifndef DRAWRINGUTILS_H
#define DRAWRINGUTILS_H

#include <math.h>
#if !defined(M_PI)
#define M_PI 3.14159265358979323846
#endif

/*
 * Calculates cartesian axes based on coords of nuclei in ring
 * using cremer-pople algorithm. It is assumed that the
 * centre of geometry is the centre of the ring.
 */
void ring_axes(const double *X, const double *Y, const double *Z, int N, 
			   double x[3], double y[3], double z[3]);


// Calculates the displacement of ring atoms from mean plane
void atom_displ_from_mean_plane(double *X, double *Y, double *Z, 
				                double *displ, int N);

int pucker_param(int N_ring_atoms, double *displ, double *q, double *phi,
                 int &m, double &Q);

#endif
