/***************************************************************************
 *cr
 *cr            (C) Copyright 1995-2007 The Board of Trustees of the
 *cr                        University of Illinois
 *cr                         All Rights Reserved
 *cr
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *      $RCSfile: CUDAKernels.h,v $
 *      $Author: johns $        $Locker:  $             $State: Exp $
 *      $Revision: 1.3 $        $Date: 2007/03/13 04:36:44 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *   Wrapper for CUDA kernels and utility functions
 *   used by the CUDAAccel C++ class 
 ***************************************************************************/
#ifndef CUDAKERNELS_H
#define CUDAKERNELS_H

#if defined(__cplusplus)
extern "C" {
#endif

/* number of CUDA devices available */
int vmd_cuda_num_devices(int *numdev);

/* retrieve device properties */
int vmd_cuda_device_props(int dev, char *name, int namelen,
                          int *revmajor, int *revminor, unsigned long *memb);


/*
 * All available CUDA kernels
 */
int vmd_cuda_vol_cpotential(long int natoms, float* atoms, float* grideners, 
                            long int numplane, long int numcol, long int numpt, 
                            float gridspacing);

#if defined(__cplusplus)
}
#endif

#endif

