/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995-2007 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: CUDAAccel.h,v $
 *	$Author: johns $	$Locker:  $		$State: Exp $
 *	$Revision: 1.2 $	$Date: 2007/03/06 07:23:33 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *   Class to store and handle enumeration and initialization of 
 *   CUDA GPU accelerator devices.
 ***************************************************************************/
#ifndef CUDACCEL_H
#define CUDACCEL_H

typedef struct {
  char name[80];
  int major;
  int minor;
  unsigned long membytes;
} cudadevprops;

/// manages enumeration and initialization of OpenGL programmable shaders
class CUDAAccel {
private:
  int cudaavail;   // whether or not the CUDA runtime is operable for VMD
  int numdevices;  // number of CUDA GPU accelerator devices available
  ResizeArray<cudadevprops> devprops;
 
public:
  CUDAAccel(void);
  virtual ~CUDAAccel(void);

  // functions for enumerating CUDA GPU accelerator devices
  // and their attributes
  void print_cuda_devices(void);
  int num_devices(void);
  const char *device_name(int dev);
  int device_version_major(int dev);
  int device_version_minor(int dev);
  unsigned long device_membytes(int dev);
};

#endif



