
#include "symbolList.h"


// Constructor
SymbolList::SymbolList(int l, Alphabet* a, char* n)
  :  alphabet(a), name(0), length(0), maxLength(l) {
  //printf("=>SymbolList\n");
  list = new Symbol* [maxLength];
  //printf("   Hey\n");
  //printf("   name = %s\n",n);
  setName(n);
  //printf("<=SymbolList\n");

  return;
}


// Constructor
SymbolList::SymbolList(int l, Alphabet* a)
  :  alphabet(a), name(0), length(0), maxLength(l) {

  list = new Symbol* [maxLength];

  return;
}


// Destructor
SymbolList::~SymbolList() {
  
  //for (int i=0; i<length; i++) {
  //  delete list[i];
  //}

  delete list;

  return;
}


// addSymbol
int SymbolList::addSymbol(Symbol* symbol) {

  if ( !alphabet->hasSymbol(symbol) ) {
    if ( alphabet->getUnknown() != 0 ) {
      printf ("Error: SymbolList - symbol not in alphabet\n");
      if ( length == maxLength ) {
	return 0;
      }
      list[length] = alphabet->getUnknown();
    }
    return 0;
  }

  if ( length == maxLength ) {
    return 0;
  }

  //list[length] = symbol->clone();
  list[length] = alphabet->getSymbol(symbol);
  length++;

  return 1;
}


// addSymbol
int SymbolList::addSymbol(char c) {
  
  if ( addSymbol(alphabet->getSymbol(c)) ) {
    return 1;
  }

  return 0;
}


// addSymbols
int SymbolList::addSymbols(char* str) {

  int len = strlen(str);
  int i=0;
  for (; i<len; i++) {
    if ( alphabet->getSymbol(str[i]) == 0) {
      return 0;
    }
  }

  for (i=0; i<len; i++) {
    addSymbol(str[i]);
  }

  return 1;
}


// getName
//   Return a copy of name
const char* SymbolList::getName() {
  
  if (name == 0) {
    return 0;
  }

  /*
  int len = strlen(name);
  char* nameString = new char[len+1];
  strncpy(nameString,name,len);
  nameString[len] = '\0';
  
  return nameString;
  */

  return name;
}


Symbol* SymbolList::getSymbol(int i) {

  if (i < length) {
    return list[i];
  }

  return 0;
}


// getAlphabet
Alphabet* SymbolList::getAlphabet() {

  return alphabet;
}


// getLength
int SymbolList::getLength() {

  return length;
}


// getMaxLength
int SymbolList::getMaxLength() {

  return maxLength;
}


// setName
//   Set name to a copy of n
int SymbolList::setName(const char* n) {

  //printf("=>setName\n");
  if (n == 0) {
    //printf("<=setName\n");
    return 0;
  }

  if (name != 0) {
    //printf("  name = %s\n",name);
    delete name;
  }

  int len = strlen(n);
  //printf("   len = %d\n",len);
  name = new char[len+1];
  strncpy(name,n,len);
  name[len] = '\0';

  //printf("<=setName\n");
  return 1;
}


// symbolsEqual
//   Returns 1 if the Symbols are the same, element-by-element,
//   in both SymbolLists; returns 0, otherwise
int SymbolList::symbolsEqual(SymbolList* sl) {

  if (getLength() != sl->getLength()) {
    return 0;
  }

  for (int i=0; i<getLength(); i++) {
    if ( !getSymbol(i)->equals(sl->getSymbol(i)) ) {
      return 0;
    }
  }

  return 1;
}


// symbolsEqual
//   Returns 1 if the Symbols are the same, element-by-element
//   ignoring gaps, in both SymbolLists; returns 0, otherwise
int SymbolList::symbolsWithoutGapsEqual(SymbolList* sl) {
  
    int i=0;   // index for this
    int j=0;   // index for sl
    while (i < getLength() && j < sl->getLength()) {
        if ( !alphabet->isGap(getSymbol(i)) && !alphabet->isGap(sl->getSymbol(j)) ) {
            
            if (!(getSymbol(i)->equals(sl->getSymbol(j))) && !alphabet->isUnknown(getSymbol(i)) && !alphabet->isUnknown(sl->getSymbol(j))) {
                return 0;
            }
            i++;
            j++;
            
        } else if (alphabet->isGap(getSymbol(i))) {
            i++;
            
        } else if ( alphabet->isGap(sl->getSymbol(j)) ) {
            j++;
        }
    }
    
    // Make sure tail is all gaps
    while (i < getLength()) {
        if (alphabet->isGap(getSymbol(i)))
            i++;
        else {
            return 0;
        }
    }
    
    // Make sure tail is all gaps
    while (j < sl->getLength()) {
        if (alphabet->isGap(sl->getSymbol(j)))
            j++;
        else {
            return 0;
        }
    }
    
    return 1;
}


// toString
//   Return a printable char* representation of the SymbolList
char* SymbolList::toString() {
  /*
    char* str = new char[(length*2)];
    
    int i=0;
    for (; i<length; i++) {
    str[i*2] = list[i]->getOne();
    str[(i*2)+1] = ' ';
    }
    i--;
    str[(i*2)+1] = '\0';
  */
  
  char* str = new char[(length+1)];

  int i=0;
  for (; i<length; i++) {
    str[i] = list[i]->getOne();
  }
  str[i] = '\0';

  return str;
}
