
#include "structureAlignment.h"



// Constructor
//
StructureAlignment::StructureAlignment(Alphabet* alpha, int mL, int mSC)
  : alphabet(alpha), length(0), maxLength(mL),
     structureCount(0), maxStructureCount(mSC) {

  alignment = new AlignedStructure* [maxLength];

  return;
}


// Constructor
//
StructureAlignment::StructureAlignment(int mL, int mSC)
  : alphabet(0), length(0), maxLength(mL),
     structureCount(0), maxStructureCount(mSC) {

  alignment = new AlignedStructure* [maxLength];

  return;
}


// Destructor
//
StructureAlignment::~StructureAlignment() {

  for (int i=0; i<structureCount; i++) {
    delete alignment[i];
  }

  delete alignment;

  return;
}


// addStructure
//
int StructureAlignment::addStructure(AlignedStructure* structure) {
  
  if (structureCount < maxStructureCount &&
      structure->getLength() <= maxLength) {
    if (alphabet == 0) {
      alphabet = structure->getAlphabet();
    }
    // Structure using a different alphabet
    else if (alphabet != structure->getAlphabet()) {
      return 0;
    }
    alignment[structureCount] = structure;
    structureCount++;
    if (length < structure->getLength()) {
      length = structure->getLength();
    }
    return 1;
  }

  return 0;
}


// getStructure
//
AlignedStructure* StructureAlignment::getStructure(int i) {

  if (i < structureCount) {
    return alignment[i];
  }

  return 0;
}


// getSymbol
//
Symbol* StructureAlignment::getSymbol(int i, int j) {

  if (i < structureCount && j < length) {
    return alignment[i]->getSymbol(j);
  }

  return 0;
}


// getCoordinate
//
Coordinate3D* StructureAlignment::getCoordinate(int i, int j) {

  if (i < structureCount && j < length) {
    return alignment[i]->getCoordinate(j);
  }

  return 0;
}


// getAlphabet
//
Alphabet* StructureAlignment::getAlphabet() {

  return alphabet;
}


// getLength
//
int StructureAlignment::getLength() {

  return length;
}


// getStructureCount
//
int StructureAlignment::getStructureCount() {

  return structureCount;
}
