/*****************************************************************************
*
*            (C) Copyright 2005 The Board of Trustees of the
*                        University of Illinois
*                         All Rights Reserved
*
******************************************************************************/

/*****************************************************************************
* RCS INFORMATION:
*
*       $RCSfile: fastaWriter.cpp,v $
*       $Author: johns $        $Locker:  $             $State: Exp $
*       $Revision: 1.1 $           $Date: 2006/08/09 17:05:47 $
*
******************************************************************************/

// $Id: fastaWriter.cpp,v 1.1 2006/08/09 17:05:47 johns Exp $

#include <stdio.h>
#include <stdlib.h>
#include "sequenceAlignment.h"
#include "fastaWriter.h"


/**
 * This method writes a sequence alignment out as a FASTA file.
 *
 * @param   filename    The name of the file to write the alignment out as.
 * @param   alignment   The sequence alignment to write out.
 * @param   lineLength  The maximum number of residues on a single line. (default=60)
 * @return  1 on success, o on error.
 */
int FASTAWriter::writeSequenceAlignment(char* filename, SequenceAlignment* alignment, int lineLength) {  
  
    //Open the file.
    FILE* fp = fopen(filename,"w");
    if (fp == NULL) {
        return 0;
    }
    
    //Go through each sequence in the alignment.
    for (int i=0; i<alignment->getSequenceCount(); i++) {
        
        //Get the sequence.
        AlignedSequence* sequence = alignment->getSequence(i);
        
        //Write out the sequence.
        fprintf(fp, ">%s\n", sequence->getName());
        for (int i=0; i<sequence->getLength(); i++) {
            if (i > 0 && i%lineLength == 0) fprintf(fp, "\n");
            fprintf(fp, "%c", sequence->getSymbol(i)->getOne());
        }
        fprintf(fp, "\n");
    }

    //Close the file.
    fclose(fp);
    
    return 1;
}
