
#include "alignedStructure.h"


// Constructor
AlignedStructure::AlignedStructure(int l, Alphabet* a, char* n)
  : Structure(l,a,n), unalignedLength(0) {

  alignedToUnaligned = new int[getMaxLength()];
  unalignedToAligned = new int[getMaxLength()];

  return;
}


// Constructor
AlignedStructure::AlignedStructure(int l, Alphabet* a)
  : Structure(l,a), unalignedLength(0) {

  alignedToUnaligned = new int[getMaxLength()];
  unalignedToAligned = new int[getMaxLength()];

  return;
}


// Constructor
AlignedStructure::AlignedStructure(Structure* structure,
				   AlignedSequence* alnSeq)
  : Structure(alnSeq->getLength(), alnSeq->getAlphabet()),
     unalignedLength(0) {

  // XXX: WHAT TO DO WHEN ARGS ARE BOGUS

  //printf("=>AlignedStructure::AlignedStructure\n");

  alignedToUnaligned = new int[getMaxLength()];
  unalignedToAligned = new int[getMaxLength()];

  Coordinate3D* coord = 0;
  int i=0;
  int j=0;
  //printf("   structure->getLength(): %d\n",structure->getLength());
  for (; i<alnSeq->getLength(), j<structure->getLength(); i++) {
    if ( getAlphabet()->isGap(alnSeq->getSymbol(i)) ) {
      addGap();
      //printf("   i: %d, j: %d\n",i,j);
    }
    else {
      //if (coord != 0) delete coord;
      //printf("   i: %d, j: %d\n",i,j);
      coord = structure->getCoordinate(j);
      //printf("%d coord: %s (%f,%f,%f)\n",j,alnSeq->getSymbol(i)->getThree(),coord->getX(),coord->getY(),coord->getZ());
      //printf("   Hey\n");
      if (coord != 0 && alnSeq->getSymbol(i) != 0) {
	addElement(alnSeq->getSymbol(i), coord);
      }
      j++;
    }
  }

  if (i < alnSeq->getLength()) {
    for (; i<alnSeq->getLength(); i++) {
      if ( !getAlphabet()->isGap(alnSeq->getSymbol(i)) ) {
	printf("  AlignedStructure::OMFG!!!\n");
      }
      else {
	addGap();
      }
    }
  }

  //printf("<=AlignedStructure::AlignedStructure\n");
  return;
}


// Destructor
AlignedStructure::~AlignedStructure() {

  return;
}


// addElement
int AlignedStructure::addElement(Symbol* symbol, float x, float y, float z) {

  if (unalignedLength == getMaxLength()) return 0;

  int success = Structure::addElement(symbol,x,y,z);

  if (success == 0) return success;

  alignedToUnaligned[getLength()-1] = unalignedLength;
  unalignedToAligned[unalignedLength] = getLength()-1;
  unalignedLength++;

  return 1;
}


int AlignedStructure::addElement(char c, float x, float y, float z) {

  if (unalignedLength == getMaxLength()) return 0;

  int success = Structure::addElement(c,x,y,z);

  if (success == 0) return success;

  alignedToUnaligned[getLength()-1] = unalignedLength;
  unalignedToAligned[unalignedLength] = getLength()-1;
  unalignedLength++;

  return 1;
}


// addElement
int AlignedStructure::addElement(Symbol* symbol, Coordinate3D* coord) {

  //printf("=>AlignedStructure::addElement\n");

  if (unalignedLength == getMaxLength()) {
    //printf("   Nope1\n");
    //printf("<=AlignedStructure::addElement\n");
    return 0;
  }

  int success = Structure::addElement(symbol,coord);

  if (success == 0) {
    //printf("   Nope2\n");
    //printf("<=AlignedStructure::addElement\n");
    return 0;
  }

  alignedToUnaligned[getLength()-1] = unalignedLength;
  unalignedToAligned[unalignedLength] = getLength()-1;
  unalignedLength++;

  //printf("   Yep1\n");
  //printf("<=AlignedStructure::addElement\n");

  return 1;
}


// addGap
int AlignedStructure::addGap() {

  //printf("=>AlignedStructure::addGap()\n");

  int success = Structure::addElement(getAlphabet()->getSymbol('-'), (Coordinate3D*)0);
  //int success = Structure::addElement(getAlphabet()->getSymbol('-'), 0.0, 0.0, 0.0);

  //printf("success: %d\n",success);

  if (success == 0) return success;
  if (unalignedLength <= getMaxLength()) {
    alignedToUnaligned[getLength()-1] = unalignedLength;
  }
  else {
    alignedToUnaligned[getLength()-1] = -1;
  }

  //printf("<=AlignedStructure::addGap()\n");

  return 1;
}


Symbol* AlignedStructure::getUnalignedSymbol(int i) {

  if (i < unalignedLength &&
      unalignedToAligned[i] >= 0) {
    return getSymbol(unalignedToAligned[i]);
  }

  return 0;
}


Coordinate3D* AlignedStructure::getUnalignedCoordinate(int i) {
  
  if (i < unalignedLength &&
      unalignedToAligned[i] >= 0) {
    return getCoordinate(unalignedToAligned[i]);
  }
  
  return 0;
}


int AlignedStructure::getUnalignedLength() {

  return unalignedLength;
}


// alignedToUnalignedIndex
//   return index of non-gapped sequence corresponding to
//   the given gapped sequence index
int AlignedStructure::alignedToUnalignedIndex(int i) {

  if (i < getLength()) {
    return alignedToUnaligned[i];
  }

  return -1;
}


// unalignedToAlignedIndex
//   return index of gapped sequence corresponding to
//   the given non-gapped sequence index
int AlignedStructure::unalignedToAlignedIndex(int i) {

  if (i < unalignedLength) {
    return unalignedToAligned[i];
  }

  return -1;
}
