/*
 * Copyright (C) 2007 by David J. Hardy.  All rights reserved.
 *
 * mgpot_longrng.c - compute long-range contribution to potentials
 */

#include "mgpot_defn.h"

void mgpot_longrng(Mgpot *mg, float *atoms, float *grideners,
    long int numplane, long int numcol, long int numpt, long int natoms,
    unsigned char *excludepos) {
  switch (mg->split) {
    case CUBIC:
      mgpot_longrng_cubic(mg, atoms, grideners,
	  numplane, numcol, numpt, natoms, excludepos);
      break;
    case QUINTIC1:
      mgpot_longrng_quintic1(mg, atoms, grideners,
	  numplane, numcol, numpt, natoms, excludepos);
      break;
    default:
      ERROR("unknown splitting\n");
      abort();
  }
}
