############################################################################
#cr                                                                       
#cr            (C) Copyright 1995-2006 The Board of Trustees of the            
#cr                        University of Illinois                         
#cr                         All Rights Reserved                           
#cr                                                                       
############################################################################


############################################################################
# RCS INFORMATION:
#
# 	$RCSfile: atomselmacros.tcl,v $
# 	$Author: johns $	$Locker:  $		$State: Exp $
#	  $Revision: 1.13 $	$Date: 2006/06/20 18:25:45 $
#
############################################################################
# DESCRIPTION:
# This file defines many standard atom-selection macros. Most of these ("Old 
# macros" and "hydrogen") used to be hard-coded in the AtomSel.C source file 
# and have been moved here for added flexibility to the user (Tcl-defined 
# macros are readable and writeable).
#
# This script is sourced by vmdinit.tcl at startup.
############################################################################



if [catch {

#############################################################################
############################# OLD MACROS ####################################
#############################################################################

### Rasmol keywords  -- note they are all lowercase!

# rasmol sets (the ones that are built into VMD are marked *)
#    AT              Acidic          Acyclic
#    Aliphatic       Alpha           Amino
#    Aromatic      * Backbone        Basic
#    Bonded          Buried          CG
#    Charged         Cyclic          Cystine
#  * Helix           Hetero          Hydrogen
#    Hydrophobic     Ions            Large
#    Ligand          Medium          Neutral
#  * Nucleic         Polar         * Protein
#    Purine          Pyrimidine      Selected
#  * Sheet         * Sidechain       Small
#    Solvent         Surface       * Turn
#  * Water

atomselect macro at "resname ADE A THY T"
atomselect macro acidic "resname ASP GLU"
atomselect macro cyclic "resname HIS PHE PRO TRP TYR"
atomselect macro acyclic "protein and not cyclic"
atomselect macro aliphatic "resname ALA GLY ILE LEU VAL"
atomselect macro alpha "protein and name CA"
atomselect macro amino "protein"
atomselect macro aromatic "resname HIS PHE TRP TYR"
atomselect macro basic "resname ARG HIS LYS HSP"
atomselect macro bonded "numbonds > 0"
atomselect macro buried "resname ALA LEU VAL ILE PHE CYS MET TRP"
atomselect macro cg "resname CYT C GUA G"
atomselect macro charged "basic or acidic"
atomselect macro hetero "not (protein or nucleic)"
atomselect macro hydrophobic "resname ALA LEU VAL ILE PRO PHE MET TRP"
atomselect macro small "resname ALA GLY SER"
atomselect macro medium "resname VAL THR ASP ASN PRO CYS ASX PCA HYP"
atomselect macro large "protein and not (small or medium)"
atomselect macro neutral "resname VAL PHE GLN TYR HIS CYS MET TRP ASX GLX PCA HYP"
atomselect macro polar "protein and not hydrophobic"
atomselect macro purine "resname ADE A GUA G"
atomselect macro pyrimidine "resname CYT C THY T URA U"
atomselect macro surface "protein and not buried"

### Rasmol sets which are not defined here:

#atomselect macro hydrogen "" ;# defined later
#atomselect macro ions "" ;# defined later
#atomselect macro ligand ""
#atomselect macro selected "" ;# cannot implemented (different philosophy)
#atomselect macro solvent "" ;# defined later



#############################################################################
############################# NEW MACROS ####################################
#############################################################################


### Molecule categories (from CHARMM topology files)

atomselect macro lipid "resname DLPE DMPC DPPC GPC LPPC PALM PC PGCL POPC POPE"
atomselect macro lipids lipid
atomselect macro ion "resname AL BA CA CAL CD CES CLA CL CO CS CU CU1 CUA HG IN IOD K MG MN3 MO3 MO4 MO5 MO6 NA NAW OC7 PB POT PT RB SOD TB TL WO4 YB ZN ZN1 ZN2"
atomselect macro ions ion
atomselect macro sugar "resname AGLC"
atomselect macro solvent "not (protein or sugar or nucleic or lipid)"


### Atomic element names

atomselect macro carbon "name \"C.*\" and not ion"
atomselect macro hydrogen "name \"\[0-9\]?H.*\""
atomselect macro nitrogen "name \"N.*\""
atomselect macro oxygen "name \"O.*\""
atomselect macro sulfur "name \"S.*\" and not ion"

### Shorthand notation

atomselect macro noh "not hydrogen"

### Common hetero structures

atomselect macro heme "resname HEM HEME"

### PDB 'altloc' conformation selection macros
atomselect macro conformationall "altloc \"\""
atomselect macro conformationA "altloc \"\" or altloc \"A\""
atomselect macro conformationB "altloc \"\" or altloc \"B\""
atomselect macro conformationC "altloc \"\" or altloc \"C\""
atomselect macro conformationD "altloc \"\" or altloc \"D\""
atomselect macro conformationE "altloc \"\" or altloc \"E\""
atomselect macro conformationF "altloc \"\" or altloc \"F\""

} errormsg] {
  puts "Error parsing atomselectmacros.tcl file: $errormsg\n"
}
