########################## external

# define the commands for an external connection

#  on     -- start me up as a server, save server port in $vmd_serverport
#  off    -- don't be a server any more (though old connections still exist)
#  host <machine1> (<machine2 ... ) -- allow/ disallow connections via dp_Host
#  connect <machine> -- connect to a server on another machine, saves
#              file id in $vmd_server. If no machine name is given, assumes
#              the local machine
#  send   -- sends RPC command to other machine
#  close  -- detach from remote server

# this is _ALSO_ set in vmdinit.tcl

proc external {opt args} {
    global vmd_serverport
    global vmd_server
    global vmd_external_port
    switch -exact -- $opt {
	on {
	    if {[info exists vmd_serverport]} {
		external off
	    }
	    external host -
	    external host +[exec hostname]
	    set vmd_serverport [dp_MakeRPCServer $vmd_external_port \
				    dp_CheckHost none 1]
	    return $vmd_serverport
	}
	off {
	    if {[info exists vmd_serverport]} {
		dp_ShutdownServer [lindex $vmd_serverport 0]
		unset vmd_serverport
	    }
	    return
	}
	host {
	    set retval {}
	    foreach name $args {
		lappend retval [dp_Host $name]
	    }
	    return $retval
	}
	    
	connect {
	    if {[llength $args] == 0} {set args [exec hostname]}
	    if {[llength $args] != 1} {
		error "external: connect: takes the hostname as an option"
	    }
	    if {[info exists vmd_server]} {
		external close
	    }
	    puts [list dp_MakeRPCClient [lindex $args 0] \
				$vmd_external_port]
	    set vmd_server [dp_MakeRPCClient [lindex $args 0] \
				$vmd_external_port]
	    return $vmd_server
	}
	send {
	    if {[info exists vmd_server]} {
		return [dp_RPC $vmd_server eval $args]
	    }
	    error "external: send: not connected"
	}
	close {
	    if {[info exists vmd_server]} {
		dp_CloseRPC $vmd_server
		unset vmd_server
	    }
	    return
	}
    }
    # if I get here, there was a problem
    error "external: unknown option '$opt'"
}
