/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: VRegionList.h,v $
 *	$Author: billh $	$Locker:  $		$State: Exp $
 *	$Revision: 1.3 $	$Date: 95/05/12 00:11:01 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *  A VRegionList is a VRegion which contains a list of VRegions.  The
 * idea is that a VRegion is list a button, or slider, and a VRegionList
 * is a menu of buttons, sliders, etc.  Since all the items are inside
 * the list, the search to find if the coordinates are outside is faster.
 * In addition, moving the list also moves the children in the list.
 *
 ***************************************************************************/
#ifndef VREGIONLIST_H
#define VREGIONLIST_H

#include "VRegion.h"
#include "DLinkList.h"

/******************************************************************/
// a VRegion List is a VRegion which contains a list of VRegions.
// The idea is that you can create a heirarchy of regions
//  I would have made this derived from the DLinkList template
// but the @#$#@$ SGI C++ compilier won't let me!
class VRegionList : public VRegion {

private:
  DLinkList<VRegion *> children;

public:
  VRegionList(float *c1, float *c2, float *c3, float *c4,
                       char *name, Scene *sc, int memsize,
                       int is_everywhere = FALSE);
  virtual ~VRegionList(void);
  virtual int check_event(float *pos, ToolControl *toolctrl);

  virtual void redraw_list(int state);

  // motions
  virtual void moveby(float *delta);
  virtual void moveto(float *newpos);
  void append(VRegion *newregion); // add to the list -- @#%@$% compilier

  // button presses - only checks children, not self
  virtual int button_event(float *pos, ToolControl *toolctrl);
  virtual void check_button(int buttonnum, int change, 
                     float *delta, ToolControl *toolctrl);

};

#endif

