/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: VMDTitle.h,v $
 *	$Author: billh $	$Locker:  $		$State: Exp $
 *	$Revision: 1.6 $	$Date: 95/05/27 06:23:46 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 * A flashy title object which is displayed when the program starts up,
 * until a molecule is loaded.
 *
 ***************************************************************************/
#ifndef VMDTITLE_H
#define VMDTITLE_H

#include "Displayable.h"
#include "DispCmds.h"
#include "Timer.h"


class VMDTitle : public Displayable3D {
private:
  DispCmdColorIndex color;
  DispCmdMaterials materials;
  DispCmdTextPos txtpos;
  DispCmdText txt1, txt2;
  Timer timer;
  void redraw_list(void);
  int letterson;
  
  // whether this has been turned off initially or not yet
  int turnedOffOnce;

public:
  VMDTitle(Scene *);
  
  // prepare to draw
  virtual void prepare(DisplayDevice *);
  
  // return whether we've toggled this off once already
  int turned_off_once(void) { return turnedOffOnce; }

  // turn off the molecule
  virtual void off(void);
};

#endif

