/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *      $RCSfile: TrackerList.C,v $
 *      $Author: billh $        $Locker:  $                $State: Exp $
 *      $Revision: 1.7 $      $Date: 95/05/12 00:00:14 $
 *
 ***************************************************************************
 * DESCRIPTION:
 * 
 * Manager for the 3D user interface, including the spatial trackers and any
 * 3D menus, pointers, etc.
 *
 ***************************************************************************/
#ifndef UIVR_H
#define UIVR_H

#include "UIObject.h"
#include "TrackerList.h"
#include "Buttons.h"
#include "VRegionList.h"

extern TrackerList *trackerList;


class UIVR : public UIObject {
public:
  Buttons *kbdButtons1;  // the different types of input buttons
  Buttons *kbdButtons2;
  Buttons *kbdButtons3;
  Buttons *pointerButtons;
  
public:
  VRegionList *vregions;     // list of the different vregions
  ResizeArray<ToolControl *> tools; // list of the different Tools  
  
public:
  UIVR(UIList *, CommandQueue *);  // constructor

  void help(void);  // print out help
  
  // update the display due to a command being executed.  Return whether
  // any action was taken on this command.
  virtual int act_on_command(int, Command *, int);

  // check for an event, and queue it if found.  Return TRUE if an event
  // was generated.
  virtual int check_event(void);

};

#endif // UIVR_H

