/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: UIText.h,v $
 *	$Author: dalke $	$Locker:  $		$State: Exp $
 *	$Revision: 1.18 $	$Date: 95/10/09 05:26:12 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 * This is the User Interface for text commands.  It reads characters from
 * the console, and executes the commands.
 *
 ***************************************************************************/
#ifndef UITEXT_H
#define UITEXT_H

#include <stdio.h>
#include <string.h>
#include "UIObject.h"
#include "Command.h"
#include "Stack.h"
#include "Timer.h"
#include "NameList.h"
#include "Inform.h"


/////////////////////////////  Text Event Object  
class TextEvent : public Command {

public:
  // the text command string
  char *cmd;

private:
  // must the string be deleted when the command is done?
  int deleteCmd;

public:
  // constructor; must specify what the text command string is, whether to
  // delete the string storage, and the the ui id
  // This string must be an allocated array
  TextEvent(char *, int = TRUE, int = (-1));

  // destructor; frees up command string memory if necessary
  virtual ~TextEvent(void);
};


#ifdef VMDTCL
typedef struct Tcl_Interp;
#endif

/////////////////////////////  Text User Interface Object   
class UIText : public UIObject {

private:
  // list of commands, and their callback functions and help messages
  NameList<TextCallback *> textProcessors;

  // do we need a prompt displayed?  also, functions to indicate we need one,
  // and to actually display it.
  int needPrompt;
  void need_prompt(void) { needPrompt = TRUE; }
  void prompt(void);

  // files to read text from, if not from stdin
  Stack<FILE *> input_files;
  
  // do we echo VMD commands back to the console after they have been entered?
  int doEcho;

  // Inform object used for echoing commands
  Inform txtMsgEcho;

  // used to delay reading inputs
  Timer mytimer;
  float delay;

public:  
  // constructor
  UIText(UIList *, CommandQueue *);

  // destructor
  virtual ~UIText(void);

#ifdef VMDTCL
  // The Tcl interpreter
  static Tcl_Interp *tclInterp;
#endif

  // return number of text commands currently understood
  int num_commands(void);

  // return the Nth word understood; NULL if error
  char *word(int);

  // add a new command to the list of commands
  void add_command(char *, TextCallback *);

  // process an argc, argv command, and return < 0 if the command is not
  // known, 0 if it was successful, or > 0 if an error occcurred
  int process_command(int, char **);

  // specify new file to read commands from
  void read_from_file(char *);

  // set the text processor to wait for the given number of seconds before
  // reading another text command
  void wait(float);

  // get/set whether to echo all VMD text commands to the console
  int echo(void) { return doEcho; }
  void echo(int yn) { doEcho = yn; }

  //
  // virtual routines for entering/processing commands and events
  //
  
  // update the display due to a command being executed.  Return whether
  // any action was taken on this command.
  // Arguments are the command type, command object, and the 
  // success of the command (T or F).
  virtual int act_on_command(int, Command *, int);
  
  // check for an event, and queue it if found.  Return TRUE if an event
  // was generated.
  virtual int check_event(void);
  
};


#endif

