/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: TclCommands.h,v $
 *	$Author: dalke $	$Locker:  $		$State: Exp $
 *	$Revision: 1.11 $	$Date: 1996/05/14 04:51:40 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *  prototypes for VMD<->Tcl functions
 *
 ***************************************************************************/
#ifndef TCLCOMMANDS_H
#define TCLCOMMANDS_H
//forward definition
class Matrix4;
class AtomSel;

// for 'vmdinfo'
int vmdinfo_tcl(ClientData , Tcl_Interp *interp, int argc, char *argv[]) ;

// for 'molinfo'
int molecule_tcl(ClientData , Tcl_Interp *interp, int argc, char *argv[]) ;

// this is in MolInfo.C, but 1) there are only two external functions there
// and 2) it could be part of TclCommand.C, so I put it here
int molinfo_get(int molid, int argc, char *argv[], Tcl_Interp *interp);
int molinfo_set(int molid, int argc, char *argv[], char *data[],
  Tcl_Interp *interp);

// for 'atomselect'
int make_tcl_atomsel(ClientData, Tcl_Interp *interp, int argc, char *argv[]);

// get the atom selection associated with the given tcl selection
// (the one of the form 'atomselect%u')
AtomSel *tcl_commands_get_sel(char *str);

// for accessing the graphics
int graphics_tcl(ClientData, Tcl_Interp *interp, int argc, char *argv[]);

// for accessing the colors
int tcl_colorinfo(ClientData, Tcl_Interp *interp, int argc, char *argv[]);

// for the interactive prompt (forms or text (if forms not available))
int feedback_tcl(ClientData, Tcl_Interp *interp, int argc, char *argv[]);

// electron density commands
int make_tcl_edm(ClientData,  Tcl_Interp *interp, int argc, char *argv[]);

// the 'foreach' from 7.5 (VMD uses 7.4)
int Tcl_ForeachCmd(ClientData, Tcl_Interp *interp, int argc, char **argv);

// override some vector functions for speed
int proc_vecadd(ClientData, Tcl_Interp *interp, int argc, char *argv[]);
int proc_vecsub(ClientData, Tcl_Interp *interp, int argc, char *argv[]);
int proc_vecscale(ClientData, Tcl_Interp *interp, int argc, char *argv[]);
int proc_transoffset(ClientData, Tcl_Interp *interp, int argc, char *argv[]);
int proc_transmult(ClientData, Tcl_Interp *interp, int argc, char *argv[]);
int proc_vectrans(ClientData, Tcl_Interp *interp, int argc, char *argv[]);

// hardcode the atomselection 'move' and 'moveby' commands
int proc_vmd_atomselect_move(ClientData, Tcl_Interp *interp, int argc, 
			     char *argv[]);
int proc_vmd_atomselect_moveby(ClientData, Tcl_Interp *interp, int argc, 
			     char *argv[]);


// get a matrix from a string; 
// returns TCL_OK if good
// If bad, returns TCL_ERROR and sets the interp->result to the error message
// The name of the function should be passed in 'fctn' so the error message
// can be constructed correctly
int tcl_get_matrix(char *fctn, Tcl_Interp *interp,
		   char *s, Matrix4 *mat);

// append the matrix information to the interp->result field
void tcl_append_matrix(Tcl_Interp *interp, const Matrix4 &mat);

// get a vector -- YOU must delete the vector, if successful
// returns TCL_OK if good
// If bad, returns TCL_ERROR and sets the interp->result to the error message
// The name of the function should be passed in 'fctn' so the error message
// can be constructed correctly
int tcl_get_vector(char *fctn, Tcl_Interp *interp, 
			  char *s, int *num, float **result);


// check that a selection
//  1) exists
//  2) has at least one selected atom
//  3) its molecule still exists
// returns one of the 'tcl_errors' or 0 if good
int check_selection(AtomSel *sel);

// returns the start of the coordinate set for this frame
// assumes the selection is good
// returns NULL if frame number was invalid
float *get_selection_coords(AtomSel *sel);

// append the double to the end of the string s
// return the end of the string
// optionally add a space at the beginning
char *tcl_append_double(char *s, double f, int add_space = 0);

#endif
