/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: Surf.C,v $
 *	$Author: dalke $	$Locker:  $		$State: Exp $
 *	$Revision: 1.1 $	$Date: 1995/08/24 21:43:09 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 ***************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <iostream.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <fstream.h>
#include <string.h>
#include <errno.h>

#include "utilities.h"
#include "Surf.h"

#define SURF_BIN "surf"
//#define SURF_TMPDIR "/usr/tmp"
extern char *VMDtempFile(const char *);
#define SURF_TMPDIR VMDtempFile("")

// these are VMD specific
#include "Inform.h"
#define cerr msgErr
#define endl sendmsg

// delete the directory
#define DELETE_TMPDIR							      \
{									      \
   char *s = new char [strlen(dirname) + 50];				      \
   strcpy(s, "/bin/rm -fr ");						      \
   strcat(s, dirname);							      \
   system(s);								      \
   delete [] s;								      \
}

// delete tmp names and return
#define CLEAN_RETURN							      \
{									      \
   if (filename) delete [] filename;					      \
   if (dirname)  delete [] dirname;					      \
   return;								      \
}


Surf::Surf(float probe_r, int num, float *r, float *x, float *y, float *z)
:triangles(100)
{
   is_okay = FALSE;
   char *dirname = NULL;
   char *filename = NULL;
   // create a temporary directory
   // first, get a good name
   char randprefix[20];
   {  // make a four digit random number
      int i = rand();
      sprintf(randprefix, "%d", i);
      randprefix[4] = 0;
   }
   if (getenv("SURF_TMPDIR")) {
      dirname = new char[strlen(getenv("SURF_TMPDIR"))+100];
      sprintf(dirname, "%s/surf%d.%sXXXXXX", getenv("SURF_TMPDIR"), getuid(),
	      randprefix);
   } else {
      dirname = new char[strlen(SURF_TMPDIR) + 100];
      sprintf(dirname, "%ssurf%d.%sXXXXXX", SURF_TMPDIR, getuid(),
	      randprefix);
   }
   mktemp(dirname);
   if (dirname[0] == 0) {
      cerr << "Cannot make new dir name for SURF: "
	   << strerror(errno) << endl;
      CLEAN_RETURN;
   }
   // make the temp directory
   {
      mode_t tmpmask = umask(0);
      umask(tmpmask);
      if (mkdir(dirname, 0544 | ~tmpmask) != 0) {
	 cerr << "Cannot create temp directory " << dirname
	      << " for SURF calculation: " << strerror(errno) << endl;
	 CLEAN_RETURN;
      }
   }
   // create the input file for that directory
   filename = new char[strlen(dirname) + strlen("/surf.in") + 20];
   strcpy(filename, dirname);
   strcat(filename, "/surf.in");

   // write everything to the data file
   {
      ofstream outfile(filename);
      for (int i=0; i<num; i++) {
	 outfile << i << " " << r[i] << " " << x[i] << " "
		 << y[i] << " " << z[i] << "\n";
      }
   }
   // call the system program for conversion
   {
      char *s;
      if (getenv("SURF_BIN")) {
	 s = new char[strlen(filename)+strlen(getenv("SURF_BIN"))+80];
	 strcpy(s, getenv("SURF_BIN"));
      } else {
	 s = new char[strlen(filename)+strlen(SURF_BIN)+80];
	 strcpy(s, SURF_BIN);
      }
      strcat(s, " ");
      {
	 char tmps[30];
	 sprintf(tmps, " -W 1 -R %f ", probe_r);
	 probe_radius = probe_r;
	 strcat(s, tmps);
      }
      strcat(s, filename);
      system(s);
      delete [] s;
   }
   
   // read the data
   strcat(filename, ".tri");

   { // read the file
      FILE *infile = fopen(filename, "r");
      if (!infile) {
	 cerr << "Cannot read SURF output file: " << filename << endl;
	 DELETE_TMPDIR;
	 CLEAN_RETURN;
      }
      while (!feof(infile)) {
	 tri tmp;
	 int count = fscanf(infile, "%d\n", &tmp.index);
	 if (count == -1) break;
	 for (int i=0; i<3; i++) {
	    count += fscanf(infile, "%f %f %f %f %f %f\n",
			    &tmp.point[i].pos[0],
			    &tmp.point[i].pos[1],
			    &tmp.point[i].pos[2],
			    &tmp.point[i].norm[0],
			    &tmp.point[i].norm[1],
			    &tmp.point[i].norm[2]);
	 }
	 if (count != 19) {
	    cerr << "Only read " << count << " elements from SURF record"
		 << endl;
	    cerr << "Was there a core dump or is the disk full?" << endl;
	    break;
	 }
	 // and add it to the list
	 triangles.append(tmp);
      }
   } // file has been read

   is_okay = TRUE;
   DELETE_TMPDIR;
   CLEAN_RETURN;
}



