/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: Residue.h,v $
 *	$Author: dalke $	$Locker:  $		$State: Exp $
 *	$Revision: 1.7 $	$Date: 96/01/30 22:53:46 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *  This is based on the uniq_resid assigned in BaseMolecule
 * A residue knows the other residues to which it is connected.  It also
 * has a list of all the atoms contained by this residue
 *
 ***************************************************************************/
#ifndef RESIDUE_H
#define RESIDUE_H

#include "Inform.h"
#include "Atom.h" // to get enums from Atom
#include "ResizeArray.h"


class Residue {
  public:
    enum BondType { PRO_PRO, NUC_NUC, OTHER };
    // these are stride definitions
    enum SStruct { HELIX_ALPHA, HELIX_3_10, HELIX_PI,
		   BETA, BRIDGE, TURN, COIL};
      
    enum { MAXRESIDUEBONDS = 4 };
    
    int idx;
    int resid; // the "real" resid
    MolAtom::ResidueType residueType;
    int bonds;
    int bondTo[MAXRESIDUEBONDS];
    BondType bondType[MAXRESIDUEBONDS];
    ResizeArray<int> atoms;
    int fragment;
    SStruct sstruct;

    Residue(int id, int realid, MolAtom::ResidueType newtype) : atoms(4) {
      idx = id;
      resid = realid;
      bonds = 0;
      residueType = newtype;
      fragment = -1;
      sstruct = COIL;
    }
    void add_atom(int atomindex) {
      atoms.append(atomindex);
    };
    
    void add_bond(int bondto) {
      int j;
      int flg = FALSE;
//      msgInfo << "checking bond from " << idx << " to " << bondto << sendmsg;
      for (j=0; j<bonds; j++) { // check uniqueness
        if (bondTo[j] == bondto) { // already there
          flg = TRUE;
          break;  // ignore repeats;  I would have a return, but the
                  // compilier doesn't allow that in inline functions
        }
      }  // new bond
      if (!flg && idx != bondto) { 
//        msgInfo << "Adding bond." << sendmsg;
        if (bonds >= MAXRESIDUEBONDS) {
          msgErr << "Uniq Residue exceeded maximim number of bonds (";
          msgErr << bonds << ")." << sendmsg;
        } else {
          bondTo[bonds++] = bondto;
        }
      }
    } // end of add_bond
    

};

#endif

