#ifndef RADIANCEDISPLAYDEVICE_H
#define RADIANCEDISPLAYDEVICE_H
/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: RadianceDisplayDevice.h,v $
 *	$Author: dalke $	$Locker:  $		$State: Exp $
 *	$Revision: 1.2 $	$Date: 96/03/24 07:07:20 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *  Writes to the format for Radiance.  For more information about that
 * package, see http://radsite.lbl.gov/radiance/HOME.html .
 *
 ***************************************************************************/


#include <stdio.h>
#include "FileRenderer.h"


class RadianceDisplayDevice : public FileRenderer {

private:

  // output file pointer
  FILE *rad_file;
  
  // output file name
  char *rad_filename;
  
  // was the file created?
  int Initialized;

protected:

  //
  // assorted graphics functions
  //
  
  void point(float *);
  void sphere(float *);
  void line(float *, float *);
  void cylinder(float *, float *, float);
  void cone(float *, float *, float); 
  void triangle(float *, float *, float *, float *, float *, float *);
  void square(float *, float *, float *, float *, float *);

  // manage the colors
  ResizeArray<float> red;
  ResizeArray<float> green;
  ResizeArray<float> blue;
  void set_color(float r, float g, float b);

   
public: 
  // constructor/destructor

  RadianceDisplayDevice(char *);
  virtual ~RadianceDisplayDevice(void);
  
  virtual int prepare3D(int = TRUE);
  virtual void update(int = TRUE);
  
}; 

#endif

