/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile$
 *	$Author: dalke $	$Locker:  $		$State: Exp $
 *	$Revision: 1.1 $	$Date: 96/02/21 16:47:44 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *   Pick on an atom to change its centering/global translation
 *
 ***************************************************************************/

#ifndef PICKMODECENTER_H
#define PICKMODECENTER_H

#include "PickMode.h"


class PickModeCenter : public PickMode {

private:
  // Pickable we're currently Centering.
  Pickable *pCenter;
  
  // pointer coords when this started
  float pPos[3];

  // need printout of name
  int needName;

public:
  // constructor & destructor: don't do much at all
  PickModeCenter(void);
  
  //
  // virtual routines to handle starting a pick, moving during a pick,
  // ending of a pick
  //
  
  //
  // virtual routines to handle starting a pick, moving during a pick,
  // ending of a pick
  //
  
  // called when a pick is begun:
  //	args = display to use, obj picked, button, tag, dim, pos
  // For 2D version: x & y are 0 ... 1, represent 'relative, scaled' coords.
  // For 3D version: x,y,z are transformed position of pointer
  virtual void pick_start(DisplayDevice *,
  				Pickable *, int, int, int, float *);
  
  // called when a pick moves:
  //	args = display to use, obj picked, button, tag, dim, pos
  // For 2D version: x & y are 0 ... 1, represent 'relative, scaled' coords.
  // For 3D version: x,y,z are transformed position of pointer
  virtual void pick_move(DisplayDevice *,
  				Pickable *, int, int, int, float *);
  
  // called when a pick ends:
  //	args = display to use, obj picked, button, tag, dim, pos
  // For 2D version: x & y are 0 ... 1, represent 'relative, scaled' coords.
  // For 3D version: x,y,z are transformed position of pointer
  virtual void pick_end(DisplayDevice *,
  				Pickable *, int, int, int, float *);
};
#endif
