/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: PickMode.h,v $
 *	$Author: billh $	$Locker:  $		$State: Exp $
 *	$Revision: 1.3 $	$Date: 95/05/11 23:31:21 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 * PickMode is the base class for all objects which perform some form
 * of processing of object selection via a pointer.  When a pointer is used
 * to select an object, the pointer is in a certain pick mode.  A PickList
 * object maintains a list of classes derived from this PickMode; virtual
 * routines in this class are called once an item has been selected, to
 * process and use the motion of the mouse at the starting, during, and end
 * of the picking process.
 *
 ***************************************************************************/
#ifndef PICKMODE_H
#define PICKMODE_H

class Pickable;
class DisplayDevice;


class PickMode {

public:
  // constructor & destructor: don't do much at all
  PickMode(void);
  virtual ~PickMode(void);
  
  //
  // virtual routines to handle starting a pick, moving during a pick,
  // ending of a pick
  //
  
  // called when a pick is begun:
  //	args = display to use, obj picked, button, tag, dim, pos
  // For 2D version: x & y are 0 ... 1, represent 'relative, scaled' coords.
  // For 3D version: x,y,z are transformed position of pointer
  virtual void pick_start(DisplayDevice *,
  				Pickable *, int, int, int, float *) = 0;
  
  // called when a pick moves:
  //	args = display to use, obj picked, button, tag, dim, pos
  // For 2D version: x & y are 0 ... 1, represent 'relative, scaled' coords.
  // For 3D version: x,y,z are transformed position of pointer
  virtual void pick_move(DisplayDevice *,
  				Pickable *, int, int, int, float *) = 0;
  
  // called when a pick ends:
  //	args = display to use, obj picked, button, tag, dim, pos
  // For 2D version: x & y are 0 ... 1, represent 'relative, scaled' coords.
  // For 3D version: x,y,z are transformed position of pointer
  virtual void pick_end(DisplayDevice *,
  				Pickable *, int, int, int, float *) = 0;
};

#endif

