/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: ParseTree.h,v $
 *	$Author: dalke $	$Locker:  $		$State: Exp $
 *	$Revision: 1.4 $	$Date: 96/01/30 22:26:38 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *  Basic data types for the yacc/lex interface and for the parse tree
 *
 ***************************************************************************/
#ifndef PARSETREE_H
#define PARSETREE_H

#include "SymbolTable.h"
#include "AtomParser.h"

// originally this was designed as a template, however, not all
// compilers handle templates w/ member functions, so we do this
// instead
#define PARSETREE_TEMP_HDR 
#define PARSETREE_TEMP_REF
#define PARSETREE_TEMP 0
// for the template version they should be
//#define PARSETREE_TEMP_HDR template <class T>
//#define PARSETREE_TEMP_REF <T>
//#define PARSETREE_TEMP 1

typedef struct symbol_data; // forward definition

// the current text used for a keyword or singleword
// This has only been tested for SINGLE, so be careful
extern const char *parsetree_nodestring;

PARSETREE_TEMP_HDR
class ParseTree {

 private:
#if PARSETREE_TEMP == 1
   T *obj;
#else
   void *obj;
#endif

   SymbolTable PARSETREE_TEMP_REF *table;
   atomparser_node *tree;
   int *selected_array;  // this are returned via evaluate
   int num_selected;

 public:
   ParseTree(/*const*/ SymbolTable PARSETREE_TEMP_REF *, atomparser_node *);
   ~ParseTree(void);
   int *evaluate(

#if PARSETREE_TEMP == 1
                 T *new_obj
#else
		 int num_atoms
#endif
);  // returns an array of flags or NULL if bad

   int evaluate(
#if PARSETREE_TEMP == 1
                 T *new_obj,
#else
		 int num_atoms,
#endif
		int *flgs
);  // sets an array of flags and returns 1, return 0 if bad
		 
 private:
   void eval_compare(atomparser_node *node, int num, int *flgs);
   symbol_data *eval_mathop(atomparser_node *node, int num, int *flgs);
   symbol_data *eval_key( atomparser_node *node, int num, int *flgs);
   symbol_data *eval_function( atomparser_node *node, int num, int *flgs);
   void eval_stringfctn( atomparser_node *node, int num, int *flgs);
   void eval_within(atomparser_node *node, int num, int *flgs);
   void eval_single(atomparser_node *node, int num, int *flgs);
   void eval_same(atomparser_node *node, int num, int *flgs);
   symbol_data *eval(atomparser_node *node, int num, int *flgs);
};

// and now the symbol_data description
// this is to simplify the use of three basic data types
// in an array situation.  It does the conversion as needed
// and can be told to change size
class symbol_data {
 public:
   SymbolTableName::symtype type;

// This "union" didn't seem to be working, so I commented it out.
//   union {   // the array
      double *dval;
      int *ival;
      GString *sval;
//   };
   int num;
   symbol_data(void);
   symbol_data(SymbolTableName::symtype new_type, int new_num);
   symbol_data(atomparser_node *node);
   ~symbol_data(void);
   void make_space(void);
   void free_space(void);
   void convert(SymbolTableName::symtype totype);
   void extend(int newnum);
};

#endif

