/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: NormalScene.h,v $
 *	$Author: billh $	$Locker:  $		$State: Exp $
 *	$Revision: 1.3 $	$Date: 95/05/11 23:31:16 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 * The Scene object, which maintains a list of Displayable objects and
 * draws them to a DisplayDevice.
 * Each Scene has a list of Displayable objects, and also a list of display
 * commands.  The command lists are used to draw the objects, the Displayable
 * objects to prepare and update objects for drawing.
 *
 * This is the basic version of the Scene, which just uses normal memory
 * for display lists, etc.
 ***************************************************************************/
#ifndef NORMALSCENE_H
#define NORMALSCENE_H

#include "Scene.h"
#include "ResizeArray.h"

#define INITLISTSIZE	32


class NormalScene : public Scene {

private:
  // 2D and 3D Displayable objects this Scene is managing
  ResizeArray<Displayable *> dispObjList2D;
  ResizeArray<Displayable *> dispObjList3D;

  // command lists we are managing
  ResizeArray<char *> cmdListArray2D;
  ResizeArray<char *> cmdListArray3D;

public:
  NormalScene(void);
  virtual ~NormalScene(void);

  //
  // virtual routines to access the specific displayable's and lists
  //
  
  // return the Nth Displayable, for the given dim (2 or 3)
  virtual Displayable *displayable2D(int);
  virtual Displayable *displayable3D(int);
 
  // return the Nth display command list, for the given dim (2 or 3)
  virtual char *disp_list2D(int n);
  virtual char *disp_list3D(int n);

  //
  // deal with command list storage, and registration of Displayables
  //
  
  // allocate/free display list storage space of specified size
  virtual char *get_disp_storage(int);
  virtual void free_disp_storage(char *);
  
  // (un)register the given Displayable & corresponding display list (of dim D)
  virtual void Register(Displayable *, char *, int);
  virtual void unRegister(Displayable *, char *, int);
  
};

#endif

