/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: NameList.h,v $
 *	$Author: billh $	$Locker:  $		$State: Exp $
 *	$Revision: 1.10 $	$Date: 95/05/11 23:20:01 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 * NameList object, which stores a list of unique names indexed in the order
 * they are added.  For each name, which acts as a key, there is an associated
 * integer value.
 *
 ***************************************************************************/
#ifndef NAMELIST_H
#define NAMELIST_H

#include "ResizeArray.h"

#define NLISTSIZE	64


template<class T>
class NameList  {

protected:
  // array of pointers to the strings; constructed by 'init'
  ResizeArray<char *> names;
  
  // integer data for the items
  ResizeArray<T> Data;

  // indices of names, in increasing sorted order
  ResizeArray<int> sortedOrder;

  // items in the list
  int Num;

public:
  // constructor and destructor
  NameList(void);
  ~NameList(void);

  //
  // query info about this class
  //

  // return number of items
  int num(void) { return Num; }

  //
  // routines for adding or retrieving names
  //

  // add a new name to the list, with a given associated value.
  // Return the index.  If already in the list, return the current index.
  int add_name(char *, const T &);

  // return the name (null-terminated) for given typecode
  char *name(int);

  // return the Nth name in sorted order (instead of order in which added)
  char *sort_name(int);

  //
  // routines for retrieving typecodes
  //

  // return the type index for the given name.  If the second argument is
  // given and is > 0, it is used as the max length of the names to check
  // for a match.  If is is <= 0, an exact match must be found.
  //	returns (-1) if no match is found
  int typecode(char *, int = (-1));

  // returns actual index of name in Nth sorted position
  int sort_typecode(int);

  //
  // routines for changing or retrieving data values
  //

  // returns the data for the given name.  If the second argument is
  // given and is > 0, it is used as the max length of the names to check
  // for a match.  If is is <= 0, an exact match must be found.
  T data(char *, int = (-1));

  // returns the data for the given index
  T data(int);

  // set the data value for the given index
  void set_data(int, const T &);

};


// useful typedefs for making NameLists of NameLists
typedef NameList<int>		*NameListIntPtr;
typedef NameList<float>		*NameListFloatPtr;
typedef NameList<char>		*NameListCharPtr;
typedef NameList<char *>	*NameListStringPtr;

#endif

