/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * DESCRIPTION:
 *   This type of Tool can be used to move the picked atom
 * Just press button 0 to start the pick and motion, and again to turn it off
 *
 * Simple move tool, derived from Tool
 ***************************************************************************/
#ifndef MOVETOOL_H
#define MOVETOOL_H

#include "Tool.h"

class MoveTool : public Tool {

private:
  // draw a cylinder with the given number of sides, and a sphere at the end
  // because of the graphics transformations already
  // done, I can assume the base is at (0,0,0) and the
  // tip is at (1,0,0).
  void draw_cylindrical_pointer(ToolInfo *info, int numsides);
  int grabbed;
  float x, y, z;

  int move_mol, move_atom;
 
public:
  MoveTool(char *name, Scene *sc, int drawlist_size = 2) 
     : Tool(name, sc, drawlist_size) {
    tip_checking = FULL;
    grabbed = FALSE;
    move_mol = move_atom = -1;
  }
  virtual void tool_event(ToolControl *toolctrl, ToolInfo *info);
  virtual void redraw_list(ToolInfo *info);
  virtual void button_event(ToolControl *toolctrl, ToolInfo *info);
  
};

#endif

