/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: MolFormsObj.h,v $
 *	$Author: billh $	$Locker:  $		$State: Exp $
 *	$Revision: 1.3 $	$Date: 95/05/11 23:18:05 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 * The on-screen menu to list current molecules, and to add/delete them.
 *
 ***************************************************************************/
#ifndef MOLFORMSOBJ_H
#define MOLFORMSOBJ_H

#include "FormsObj.h"


class MolFormsObj : public FormsObj {

private:
  // set the state of the molecule browser
  void reset_mol_browser(void);
  
protected:
  // check if the given forms pointer is one for this menu, and generate
  // a command if necessary.  Return 'TRUE' if the pointer is for an object
  // in this menu.
  virtual int check(FL_OBJECT *);

  // do form-specific acting on commands
  virtual int forms_act_on_command(int, Command *, int);

public:
  // class constructor and destructor
  MolFormsObj(UIList *, CommandQueue *, int, int, int * = NULL);

  //
  // virtual routines for UI init/display
  //
  
  // initialize the user interface
  virtual void init(void);
  
  // reset the user interface (forces update of all info displays)
  virtual void reset(void);

};

#endif

