/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: GrabTool.C,v $
 *	$Author: dalke $	$Locker:  $		$State: Exp $
 *	$Revision: 1.5 $	$Date: 95/12/19 17:29:25 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *   Code for the Tool which can pick up molecules
 *
 ***************************************************************************/

#include "GrabTool.h"
#include "ToolControl.h"
#include "Buttons.h"
#include "CmdTrans.h"
#include "CommandQueue.h"
#include "Global.h"


void GrabTool::redraw_list(ToolInfo *info) {
  
  reset_disp_list();  // clear out everything
  
  // the default picture is a simple cylinder with a cone end
  switch (info->detail ) {
    case 1:  // draw a simple line with a cheap end
       {float tip[3]  = {1,0,0}; 
       float base[3] = {0,0,0};
       drawcolor.putdata(info -> toolid, this);  // color each tool differently
       drawline.putdata(base, tip, this);  // line
        base[0] = 0.9;
        base[1] = 0.1;
       drawcolor.putdata(info -> toolid + 1, this);
        drawline.putdata(base, tip, this);  // and tip
        base[1] = -base[1];
        drawline.putdata(base, tip, this);
        base[2] = base[1];
        base[1] = 0.0;
        drawline.putdata(base, tip, this);
        base[1] = -base[1];
        drawline.putdata(base, tip, this);}
      break;
    case 2:  // draw a cylinder with different sized radii
       draw_cylindrical_pointer(info, 3);
      break;
    case 3:
       draw_cylindrical_pointer(info, 4);
      break;
    case 4:
       draw_cylindrical_pointer(info, 6);
      break;
    case 5:
       draw_cylindrical_pointer(info, 10);
      break;
    case 6:
       draw_cylindrical_pointer(info, 16);
      break;
    case 7:  // include material characteristics
       drawmaterials.putdata(TRUE, this);
       draw_cylindrical_pointer(info, 12);
       drawmaterials.putdata(FALSE, this);
      break;
    case 8:
       drawmaterials.putdata(TRUE, this);
       draw_cylindrical_pointer(info, 12);
       drawmaterials.putdata(FALSE, this);
      break;
    case 9:
       drawmaterials.putdata(TRUE, this);
       draw_cylindrical_pointer(info, 16);
       drawmaterials.putdata(FALSE, this);
      break;
    case 10: 
       drawmaterials.putdata(TRUE, this);
       draw_cylindrical_pointer(info, 24);
       drawmaterials.putdata(FALSE, this);
      break;
    default:  // same as 5
       draw_cylindrical_pointer(info, 10);
      break;
  }
}

//
//                     (x=.7142 == 1-(1-.8)(1.0/.7)  , r=1*radius)
//                    )
//   ------------------)  (x=.8*len, r=0.7*radius)
//                      )
//                       )  ( x = 1, r = 0)
void GrabTool::draw_cylindrical_pointer(ToolInfo *info, int numsides)
{
  if (numsides < 3) numsides = 3;
  if (numsides > 30) numsides = 30;
  float base[3] = {0.0,0.0,0.0};
  float tip[3] = {0.8, 0.0, 0.0};
  drawcolor.putdata(info -> toolid, this);  // color each tool differently
  drawcylinder.putdata(base, tip, 0.7, numsides, this);
  base[0] = 1.0-(1.0-.8)/.7;
  tip[0] = 1.0;
  drawcolor.putdata(REGSILVER, this);
  drawcylinder.putdata(base, tip, 1, numsides, this);
}

// Am I grabbing anything?  If so, move it
void GrabTool::tool_event(ToolControl *, ToolInfo *toolinfo)
{
   // if I was clever I would combine the translation and rotation in on step
  float newx = toolinfo -> tip[0];  // get the current position
  float newy = toolinfo -> tip[1];
  float newz = toolinfo -> tip[2];

  float tmptmp[16];                 // get the current orientation
  memset(tmptmp, 0, 16*sizeof(float));
  memcpy(tmptmp  , toolinfo->orient  , 3*sizeof(float));
  memcpy(tmptmp+4, toolinfo->orient+3, 3*sizeof(float));
  memcpy(tmptmp+8, toolinfo->orient+6, 3*sizeof(float));
  tmptmp[15] = 1.0;
  Matrix4 tmprot(tmptmp);
  //  msgErr << "tmprot is ====>>> " << tmprot << sendmsg;

  if (grabbed) {
    // tell system to move by the same amount the tip moved
    commandQueue -> append( new CmdTranslate( newx - x, newy - y, newz - z, 
            CmdTranslate::BY));

    // and compute the change in rotation
    rot.inverse();
    commandQueue -> append( new CmdRotMat(tmprot * rot, CmdRotate::BY));
  }
  x = newx;
  y = newy;
  z = newz;
  rot = tmprot;
}


// check which button was pushed, and change the appropriate state 
void GrabTool::button_event(ToolControl *, ToolInfo *info)
{
  Buttons *checkbuttons;
  if (!(checkbuttons=info -> buttons))
    return;
  
  // if button 0 was pressed, change attachement states
  if (checkbuttons -> change(0) == 1) {
    grabbed = !grabbed;
  }
  if (grabbed) {
     // initialize the rotation and translation matricies
     x = info -> tip[0];  // get the current position
     y = info -> tip[1];
     z = info -> tip[2];
     float tmptmp[16];                 // get the current orientation
     memset(tmptmp, 0, 16*sizeof(float));
     memcpy(tmptmp  , info->orient  , 3*sizeof(float));
     memcpy(tmptmp+4, info->orient+3, 3*sizeof(float));
     memcpy(tmptmp+8, info->orient+6, 3*sizeof(float));
     tmptmp[15] = 1.0;
     Matrix4 tmprot(tmptmp);
     rot = tmprot;
  }
}

