/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: DrawForce.h,v $
 *	$Author: billh $	$Locker:  $		$State: Exp $
 *	$Revision: 1.3 $	$Date: 95/11/05 08:20:14 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 * Another Child Displayable component for a remote molecule; this displays
 * and stores the information about the interactive forces being applied to
 * the molecule.  If no forces are being used, this draws nothing.
 *
 * The force information is retrieved from the Atom list in the parent
 * molecule.  No forces are stored here.
 *
 ***************************************************************************/
#ifndef DRAWFORCE_H
#define DRAWFORCE_H

#include "Displayable.h"
#include "DispCmds.h"
class DrawMolecule;


class DrawForce : public Displayable3D {

 private:
  // parent molecule
  DrawMolecule *mol;

  // useful drawing command objects, used to create display list
  DispCmdColorIndex cmdColorIndex;
  DispCmdLine cmdLine;
  DispCmdMaterials cmdMaterials;
  DispCmdLineType cmdLineType;
  DispCmdLineWidth cmdLineWidth;
  DispCmdPickPoint pickPoint;
  DispCmdCone cmdCone;

  // regenerate the command list
  void create_cmdlist(void);

  // do we need to completely redraw the list?
  int needRegenerate;

  // color category we're using for our colors
  int colorCat;

  // pick mode index for the force-generation picking modes
  int atomForcePickMode;
  int resForcePickMode;
  int fragForcePickMode;

  // number of force items we're currently drawing
  int forceItemsDrawn;

 protected:
  //
  // virtual functions used to act as a ColorUser object
  //

  // virtual function which is called when a new colorlist is provided.
  // may not need to do anything, which is the default cause
  virtual void do_use_colors(void);

  // do action due to the fact that a color for the given ColorList for
  // the specified category has changed
  virtual void do_color_changed(ColorList *, int);

  //
  // protected virtual function used to act as a Pickable object
  //

  // creates a new pick mode of a type specified by the code integer argument.
  // this is typically only used by add_pick_mode; the code is both defined
  // by and used by the derived class
  virtual PickMode *create_pick_mode(int);

 public:
  // constructor: parent molecule
  DrawForce(DrawMolecule *);

  //
  // public virtual routines
  //
  
  // prepare for drawing ... do any updates needed right before draw.
  virtual void prepare(DisplayDevice *);

  //
  // protected virtual function used to act as a Pickable object
  //

  // return if we are interested in the given pick mode or not
  virtual int want_pick_mode(int);

  // return whether the pickable object is being displayed
  virtual int pickable_on(void);

  // called when a pick is begun:
  //    args = display to use, obj picked, button, mode, tag, dim, pos
  // For 2D version: x & y are 0 ... 1, represent 'relative, scaled' coords.
  // For 3D version: x,y,z are transformed position of pointer
  virtual void pick_start(DisplayDevice *, Pickable *,
                                int, int, int, int, float *);

  // called when a pick moves:
  //    args = display to use, obj picked, button, mode, tag, dim, pos
  // For 2D version: x & y are 0 ... 1, represent 'relative, scaled' coords.
  // For 3D version: x,y,z are transformed position of pointer
  virtual void pick_move(DisplayDevice *, Pickable *,
                                int, int, int, int, float *);
  
};

#endif

