/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: ColorFormsObj.C,v $
 *	$Author: dalke $	$Locker:  $		$State: Exp $
 *	$Revision: 1.7 $	$Date: 96/05/14 04:48:58 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 * The on-screen menu for changing the mapping of names->colors, and the
 * definitions of the colors themselves.
 *
 ***************************************************************************/

#include "ColorFormsObj.h"
#include "CmdColor.h"
#include "Global.h"
#include "ColorList.h"

// commands we are interested in
static int numCmds = 6;
static int cmdList[6] = { Command::COLOR_CHANGE,
	Command::COLOR_NAME,		Command::COLOR_SCALE_METHOD,
	Command::COLOR_SCALE_MIDPOINT,	Command::COLOR_SCALE_MIN,
	Command::COLOR_SCALE_MAX };

/////////////////////////  constructor  
ColorFormsObj::ColorFormsObj(UIList *uil, CommandQueue *cq,
	int sh,int bd,int *npos) : FormsObj("color", uil, cq, bd, npos) {
	
  // set values of common menu elements
  form = colorMenu;
  lightButton = color_menu_button;
  offButton = color_menu_off;
  
  // register which commands we are interested in
  for(int i=0; i < numCmds; command_wanted(cmdList[i++]));
  
  // turn on if required
  if(sh)
    On();
    
  // indicate we're not yet editing any colors
  colorCat = colorName = (-1);
  resetColorBrowser = TRUE;
}

/////////////////////////  private routines  

// fill the color name browser for the color mapping, and select the proper
// item based on the selection in the color object browser
void ColorFormsObj::fill_color_name_browser(void) {
  if(!colors)
    return;

  freeze();
    if(colorCat >= 0 && colorName >= 0) {
      int cdata = (colors->color_category(colorCat))->data(colorName);
      fl_select_browser_line(color_category_colors, cdata + 1);
      if(resetColorBrowser) {
        fl_show_object(color_category_colors);
        fl_set_browser_topline(color_category_colors, cdata + 1);
        resetColorBrowser = FALSE;
      }

      // need to change color editing controls as well
      if(cdata != (fl_get_browser(color_edit_colors) - 1)) {
	fl_select_browser_line(color_edit_colors, cdata + 1);
	fl_set_browser_topline(color_edit_colors, cdata + 1);
	reset_edited_color();
      }
    } else {
      fl_hide_object(color_category_colors);
      resetColorBrowser = TRUE;
    }
  unfreeze();
}


// fill the color object browser based on the selection in the color category
// browser
void ColorFormsObj::fill_color_object_browser(void) {
  if(!colors)
    return;

  freeze();
    fl_clear_browser(color_category_names);

    // if a category is selected, fill the names and colors browser
    if(colorCat >= 0) {
      NameListIntPtr cCat = colors->color_category(colorCat);
      int cnames = cCat->num();
      for(int i=0; i < cnames; i++)
        fl_add_browser_line(color_category_names, cCat->name(i));
      if(colorName >= 0 && colorName < cnames) {
        fl_select_browser_line(color_category_names, colorName + 1);
        fl_set_browser_topline(color_category_names, colorName + 1);
      } else
        colorName = (-1);
    }

    // fill the other browsers, if necessary
    fill_color_name_browser();
  unfreeze();
}


// reset all the browsers showing the colors to assign
void ColorFormsObj::reset_color_browsers(void) {
  int i;

  if(!colors)
    return;

  freeze();
    fl_clear_browser(color_categories);

    // fill the color category browser first
    int ccats = (colors->color_categories()).num();
    fl_clear_browser(color_categories);
    for(i=0; i < ccats; i++)
      fl_add_browser_line(color_categories,
      				 (colors->color_categories()).name(i));
    if(colorCat >= 0 && colorCat < ccats) {
      fl_select_browser_line(color_categories, colorCat + 1);
      fl_set_browser_topline(color_categories, colorCat + 1);
    } else
      colorCat = (-1);

    // fill the other browsers, if necessary
    fill_color_object_browser();
  unfreeze();
}


// reset the color sliders, based on the current selection in the menu
void ColorFormsObj::reset_edited_color(void) {
  int whichCol = fl_get_browser(color_edit_colors) - 1;

  if(!colors || whichCol < 0)
    return;

  freeze();
    // get color, and set sliders
    float *newcol = colors->color(REGCOLOR(whichCol));
    fl_set_slider_value(color_edit_red, newcol[0]);
    fl_set_slider_value(color_edit_green, newcol[1]);
    fl_set_slider_value(color_edit_blue, newcol[2]);
  unfreeze();
}


// reset the color scale controls
void ColorFormsObj::reset_color_scale(void) {

  if(!colors) {
    return;
  }

  freeze();
    fl_set_choice(color_scale_method, colors->scale_method() + 1);
    fl_set_counter_value(color_scale_min, colors->scale_min());
    fl_set_counter_value(color_scale_midpoint, colors->scale_midpoint());
  unfreeze();
}


//////////////////////  protected virtual routines  

// routine to check the main form for use
int ColorFormsObj::check(FL_OBJECT *obj) {

  if(obj == color_categories) {
    if((fl_get_browser(obj) - 1) != colorCat) {
      colorCat = fl_get_browser(obj) - 1;
      colorName = (-1);
      fill_color_object_browser();
    }
    
  } else if(obj == color_category_names) {
    if((fl_get_browser(obj) - 1) != colorName) {
      resetColorBrowser = TRUE;
      colorName = fl_get_browser(obj) - 1;
      fill_color_name_browser();
    }
    
  } else if(obj == color_category_colors) {
    addcommand(new CmdColorName(
      (char *) fl_get_browser_line(color_categories,
				   fl_get_browser(color_categories)), 
      (char *) fl_get_browser_line(color_category_names,
				   fl_get_browser(color_category_names)),
      (char *) fl_get_browser_line(color_category_colors,
				   fl_get_browser(obj)),
      id()));
  
  } else if(obj == color_edit_colors) {
    reset_edited_color();
    
  } else if(obj == color_edit_tie) {
    // do nothing

  } else if(obj == color_edit_default) {
    int cnum = fl_get_browser(color_edit_colors) - 1;
    if(cnum >= 0)		// a color is being edited
      addcommand(new CmdColorChange(
		(char *) fl_get_browser_line(color_edit_colors,cnum+1), id()));

  } else if(obj == color_edit_red || obj == color_edit_green ||
  		obj == color_edit_blue || obj == color_edit_white ||
		obj == color_edit_black) {
    int cnum = fl_get_browser(color_edit_colors) - 1;
    if(cnum >= 0) {		// a color is being edited
      float r,g,b;
      if(obj == color_edit_white)
        r = g = b = 1.0;
      else if(obj == color_edit_black)
        r = g = b = 0.0;
      else {
        if(fl_get_button(color_edit_tie)) {
          r = g = b = fl_get_slider_value(obj);
        } else {
          r = fl_get_slider_value(color_edit_red);
          g = fl_get_slider_value(color_edit_green);
          b = fl_get_slider_value(color_edit_blue);
        }
      }
      addcommand(new CmdColorChange(
      			(char *) fl_get_browser_line(color_edit_colors,cnum+1),
			r, g, b, id()));
      { // change the transparent versions as well
	char s[30];
	sprintf(s, "trans_%s",
		(char *) fl_get_browser_line(color_edit_colors,cnum+1));
	addcommand(new CmdColorChange(s, r, g, b, id()));
      }
    }

  } else if(obj == color_scale_method) {
    addcommand(new CmdColorScaleMethod(fl_get_choice(obj) - 1, id()));
  
  } else if(obj == color_scale_midpoint) {
    addcommand(new CmdColorScaleMidpoint(fl_get_counter_value(obj), id()));
  
  } else if(obj == color_scale_min) {
    addcommand(new CmdColorScaleMin(fl_get_counter_value(obj), id()));
  
  } else
    return FALSE;

  return TRUE;
}


// do form-specific acting on commands.  Return whether
// any action was taken on this command.
// Arguments are the command type, command object, and the 
// success of the command (T or F).
// here, don't need this, just take parent class version
int ColorFormsObj::forms_act_on_command(int type, Command *cmd, int) {

  MSGDEBUG(3,"ColorFormsObj: acting on command " << type << sendmsg);

  // check all the possible commands that we look for ...
  if(type == Command::COLOR_SCALE_METHOD
  	|| type == Command::COLOR_SCALE_MIDPOINT
	|| type == Command::COLOR_SCALE_MIN
	|| type == Command::COLOR_SCALE_MAX) {
    reset_color_scale();

  } else if(type == Command::COLOR_CHANGE) {
    if(((CmdColorChange *)cmd)->colIndex ==
    	 (fl_get_browser(color_edit_colors) - 1))
      reset_edited_color();

  } else if(type == Command::COLOR_NAME) {
    if(((CmdColorName *)cmd)->colCatIndex == colorCat &&
    		((CmdColorName *)cmd)->colNameIndex == colorName)
      fill_color_name_browser();

  } else
    // unknown command type
    return FALSE;
    
  return TRUE;
}


//////////////////////  public virtual routines  

// initialize the user interface
void ColorFormsObj::init(void) {
  int i;
 
  freeze();
    // set all the basic values for controllers, etc
    fl_set_counter_bounds(color_scale_min, -1.0, 1.0);
    fl_set_counter_bounds(color_scale_midpoint, 0.0, 1.0);
    fl_set_counter_step(color_scale_min, 0.01, 0.1);
    fl_set_counter_step(color_scale_midpoint, 0.01, 0.1);
    fl_set_counter_precision(color_scale_min, 2);
    fl_set_counter_precision(color_scale_midpoint, 2);

    // fill the browsers with names of colors
    fl_clear_browser(color_edit_colors);
    fl_clear_browser(color_category_colors);
    for(i=0; i < REGCLRS; i++) {
      fl_add_browser_line(color_edit_colors, colors->colorNames.name(i));
      fl_add_browser_line(color_category_colors, colors->colorNames.name(i));
    }

    // fill the choice object with the possible color scale methods
    fl_clear_choice(color_scale_method);
    for(i=0; i < ColorList::SCALE_TOTAL; i++)
      fl_addto_choice(color_scale_method, colorScaleMethod[i]);

    // do a reset to set initial values
    reset();

  unfreeze();
}


// reset the user interface
void ColorFormsObj::reset(void) {
  freeze();
    reset_color_browsers();
    reset_edited_color();
    reset_color_scale();
  unfreeze();
}

