/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: CmdTracker.h,v $
 *	$Author: dalke $	$Locker:  $		$State: Exp $
 *	$Revision: 1.7 $	$Date: 95/06/01 22:53:22 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *  The Cmds to start and pause a tracker are defined here
 *
 ***************************************************************************/
#ifndef CMDTRACKER_H
#define CMDTRACKER_H

#include "Command.h"
#include "utilities.h"

// these are the Commands used:
//      TRACKER_START, TRACKER_PAUSE, TRACKER_LIST, TRACKER_LIST_AVAIL,
//      TRACKER_LOC, TRACKER_UNPAUSE,

// text callback routine for 'tracker'
extern int text_cmd_tracker(int, char **, CommandQueue *, int);


/////////////////////////// Start a tracker
class CmdTrackerStart : public Command  {

private:
  int availnum;
  char *hostname;

protected:
  virtual int do_execute(void);
  virtual void create_text(void);

public:
  CmdTrackerStart(int, char *, int = (-1));
  CmdTrackerStart(int, int = (-1));
  virtual ~CmdTrackerStart(void);
};


/////////////////////////// Pause a tracker, given its number on the list
class CmdTrackerPause : public Command {

private:
  int trackernum;

protected:
  virtual int do_execute(void);
  virtual void create_text(void);

public:
  CmdTrackerPause(int, int = -1);
};


/////////////////////////// Unpause a tracker, given its number on the list
class CmdTrackerUnpause : public Command {

private:
  int trackernum;

protected:
  virtual int do_execute(void);
  virtual void create_text(void);

public:
  CmdTrackerUnpause(int, int = -1);
};


/////////////////////////// list all the available trackers
class CmdTrackerListAvail : public Command {

protected:
  virtual int do_execute(void);
  virtual void create_text(void);

public:
  CmdTrackerListAvail(int = -1);
};


/////////////////////////// list all running trackers
class CmdTrackerList : public Command {

protected:
  virtual int do_execute(void);
  virtual void create_text(void);

public:
  CmdTrackerList(int = -1);
};
    

///////////////////////// print the current location of a tracker/ sensor pair
class CmdTrackerLoc : public Command {

private:
  int trackernum;
  int sensornum;

protected:
  virtual int do_execute( void);
  virtual void create_text(void);

public:
  // constructor: tracker #, sensor #, ui id
  CmdTrackerLoc(int, int, int = -1);
};


///////////////////// set the tracker/ sensor position
class CmdTrackerSetPos : public Command {
 private:
   int trackernum, sensornum;
   float x, y, z;
 protected:
   virtual int do_execute(void);
   virtual void create_text(void);
 public:
   CmdTrackerSetPos(int tracker, int sensor, float newx, float newy,
		    float newz, int uiid);
};
///////////////////// modify (offset) the tracker/ sensor position
class CmdTrackerModPos : public Command {
 private:
   int trackernum, sensornum;
   float x, y, z;
 protected:
   virtual int do_execute(void);
   virtual void create_text(void);
 public:
   CmdTrackerModPos(int tracker, int sensor, float newx, float newy,
		    float newz, int uiid);
};
///////////////////// set the tracker/ sensor orientation
class CmdTrackerSetOrient : public Command {
 private:
   int trackernum, sensornum;
   float orient[9];
 protected:
   virtual int do_execute(void);
   virtual void create_text(void);
 public:
   CmdTrackerSetOrient(int tracker, int sensor, float *neworient, int uiid);
};
///////////////////// modify (multiply) the tracker/ sensor orientation
class CmdTrackerModOrient : public Command {
 private:
   int trackernum, sensornum;
   float orient[9];
 protected:
   virtual int do_execute(void);
   virtual void create_text(void);
 public:
   CmdTrackerModOrient(int tracker, int sensor, float *neworient, int uiid);
};

#endif

