/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: CmdRender.C,v $
 *	$Author: dalke $	$Locker:  $		$State: Exp $
 *	$Revision: 1.8 $	$Date: 95/09/23 18:38:58 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *  Render a scene (so far, there is only one, the global one) as some
 * sort of rendered output; postscipt, rayshade, POVray, raster3D, etc.
 *
 ***************************************************************************/

#include <stdlib.h>

#include "CmdRender.h"
#include "Scene.h"
#include "DisplayDevice.h"
#include "FileRenderList.h"
#include "CommandQueue.h"
#include "Global.h"
#include "utilities.h"

// the following uses only the Cmdtypes RENDER and RENDERLIST

////////////////////////////////////////////////////////////////////
///////////////////////  text processors
////////////////////////////////////////////////////////////////////

// text callback routine for 'render'; return TRUE if an error occurs.
int text_cmd_render(int argc, char **argv, CommandQueue *cmdQueue, int id) {

  if(argc >= 3) {
    char *extstr = NULL;
    if(argc > 3)
      extstr = combine_arguments(argc, argv, 3);
    cmdQueue->append(new CmdRender(argv[1], argv[2], extstr, id));
    if(extstr)
      delete [] extstr;

  } else if (argc == 2 && !strupncmp(argv[1], "list", CMDLEN)) {
    cmdQueue->append(new CmdRenderList(id));

  } else
    return TRUE;

  // if here, everything worked out ok
  return FALSE;
}


///////////////////////// render the global scene
CmdRender::CmdRender(char *newmethod, char *newfilename, char *newcmd, int id)
	: Command(Command::RENDER, id) {
  sc = ::scene;				// get the global scene
  display = ::display;			// ditto for disp. dev.
  filename = stringdup(newfilename);
  method = stringdup(newmethod);
  extcmd = (newcmd ? stringdup(newcmd) : NULL);
}

CmdRender::~CmdRender(void) {
  delete [] filename;
  delete [] method;
  if(extcmd)  delete [] extcmd;
}

int CmdRender::do_execute(void) {
  // do the rendering
  msgInfo << "Rendering current scene to '" << filename << "' ..." << sendmsg;
  int retval = sc -> filedraw(method, filename, display);

  // if successful, execute external command
  if(retval && extcmd && *extcmd != '\0') {
    char *strbuf = new char[strlen(extcmd) + strlen(filename) + 16];
    sprintf(strbuf, extcmd, filename, filename, filename, filename, filename);
    msgInfo << "Executing post-render cmd '" << extcmd << "' ..." << sendmsg;
    start_wait();
      system(strbuf);
    stop_wait();
  }

  // return result
  msgInfo << "Rendering complete." << sendmsg;
  return retval;
}

void CmdRender::create_text(void) {
  *cmdText << "render " << method << " " << filename;
  if(extcmd)
    *cmdText << " " << extcmd;
  *cmdText << ends;
}


/////////////////////// list the available rendering types
CmdRenderList::CmdRenderList(int id) : Command(Command::RENDERLIST, id) { }

int CmdRenderList::do_execute(void) {
   if (fileRenderList->num() == 0) {
     msgInfo << "There are currently no possible output formats." << sendmsg;
   } else {
     msgInfo << "The valid image output formats are:" << sendmsg;
     for (int i=0; i<fileRenderList->num(); i++) {
       msgInfo << i+1 << "  " << fileRenderList->name(i) << sendmsg;
     }
   }

   return TRUE;
}

void CmdRenderList::create_text(void) {
  *cmdText << "render list" << ends;
}


