/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: CmdExternal.h,v $
 *	$Author: billh $	$Locker:  $		$State: Exp $
 *	$Revision: 1.1 $	$Date: 95/05/11 22:06:07 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 * Commands to control the state of the Mouse object
 *
 ***************************************************************************/
#ifndef CMDMOUSE_H
#define CMDMOUSE_H

#include "Command.h"


// The following use MOUSE_MODE

// text callback routine for 'mouse'
extern int text_cmd_mouse(int, char **, CommandQueue *, int);


////////////////////// change the current mouse mode ... this command
////////////////////// does not generate an output text command, it is just
////////////////////// used to change the VMD internal state
class CmdMouseMode : public Command {
private:
  // mode and setting for the mouse
  int mouseMode, mouseSetting;

protected:
  virtual int do_execute(void);

public:
  // specify new mode and setting
  CmdMouseMode(int, int, int = -1);
};


#endif

