/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *      $RCSfile: AtomSel.h,v $
 *      $Author: dalke $        $Locker:  $                $State: Exp $
 *      $Revision: 1.16 $      $Date: 96/03/20 17:51:36 $
 *
 ***************************************************************************
 * DESCRIPTION:
 * 
 * Parse and maintain the data for selecting atoms.
 *
 ***************************************************************************/
#ifndef ATOMSEL_H
#define ATOMSEL_H

class MoleculeList;
class BaseMolecule;

// default atom selection, and max cmd string size
#define DEFAULT_ATOMSEL "all"


#include "SymbolTable.h"
#include "ParseTree.h"
// defined and located in Global.h/C, set in AtomSel.C

// This interacts with the AtomParser
class AtomSel {
 private:
   MoleculeList *molList;
   BaseMolecule *mol;    // this is "my" molecule
   ParseTree *tree;      // this is the result of a selection

public:
   // NO_PARSE if the string is not correct
   // NO_MOL if there is no molecule
   enum {NO_PARSE = -1, NO_MOL = -2};
   // string with the selection command
   char *cmdStr;
  
  // array of flags, one for each atom in given molecule; 1=selected, 0=not
  int *on;

  // index of mol  -- because 'mol' cannot always be trusted
  int molid;
  // total number of atoms in mol
  int num_atoms;
  // total number of selected atoms the molecule
  int selected;
  
  enum {TS_LAST = -2, TS_NOW = -1};
  int which_frame;

  AtomSel(MoleculeList *);
  AtomSel(AtomSel &);
  ~AtomSel(void);
  
  // equal operator, to change the current settings.
  AtomSel& operator=(const AtomSel &);

  // for the given molecule, find atoms for the molecule.  Stores the indices
  // in 'on' for quick retrieval later.
  // return total number of atoms selected for the molecule
  // or NO_MOL or NO_PARSE if there was an error
  int find(BaseMolecule *);

  // provide new settings; does a 'find' at the end if a mol has
  // been previously provided and returns the results
  int change(char *newcmd);
  
  // return the BaseMolecule pointer (or NULL if deleted)
  BaseMolecule *molecule(void);

  // hack to set the 'atom_sel_mol' variable when data is used indirectly
  // via atomSelParser (that was a bad way to do things in the first place)
  void use(void);

  // get the current coordinates (or NULL if it doesn't exist/ no molecule)
  float *coordinates(void);
    

};

#endif

