/**********************************************************************
 *         Copyright (C) 1995  The Board of Trustees of               *
 *                             the University of Illinois             *
 *                                                                    *
 *  This file is part of the RAPP software package, a library and     *
 *  associated programs for coordinating client/server applications.  *
 *                                                                    *
 **********************************************************************/

/* rapp_errno.h: Header for for RAPP error reporting.
 *
 * Rick Kufrin <r-kufrin@uiuc.edu>
 * National Center for Supercomputing Applications
 * May, 1995
 * 
 */

#ifndef _RAPP_ERRNO_H
#define _RAPP_ERRNO_H

#ifndef _RAPP_H
#include <rapp.h>
#endif

#define RAPP_EOK            0
#define RAPP_EDATANOTREADY  1
#define RAPP_EAPPDONE       2
#define RAPP_EINCOPTLIST    3
#define RAPP_EINVALOPTLIST  4
#define RAPP_EPROTO         5
#define RAPP_EUNKNOWNHOST   6
#define RAPP_EBADAPP        7
#define RAPP_EINIT          8
#define RAPP_ENOTCONNECTED  9
#define RAPP_ESOCK         10
#define RAPP_ENOMEM        11
#define RAPP_EUNKNOWNMACH  12
#define RAPP_EREFUSED      13
#define RAPP_EDAEMON       14
#define RAPP_ECONSUMER     15
#define RAPP_EBADVERSION   16
#define RAPP_ESEM          17
#define RAPP_ESHMEM        18
#define RAPP_ECONV         19
#define RAPP_EEXEC         20
#define RAPP_EREXEC        21
#define RAPP_EBADUSER      22
#define RAPP_EPIPE         23
#define RAPP_EBADDIR       24
#define RAPP_EAUTH         25
#define RAPP_EUNSUPPORTED  26
#define RAPP_EMANAGER      27
#define RAPP_EFORK         28
#define RAPP_EBADCONSUMER  29
#define RAPP_ENOJOBS       30
#define RAPP_EBADRATE      31
#define RAPP_ESELECT       32
#define RAPP_ESENDSTATIC   33
#define RAPP_ERECVSTATIC   34
#define RAPP_ESENDDYNAMIC  35
#define RAPP_ERECVDYNAMIC  36
#define RAPP_EBADDAEMON    37
#define RAPP_EMAP          38
#define RAPP_EDUPHANDLER   39
#define RAPP_ENOHANDLER    40

extern void rapp_perror(char *msg);
extern char *rapp_errlist[];
extern int rapp_errno;

#endif /* _RAPP_ERRNO_H */
