/**********************************************************************
 *         Copyright (C) 1995  The Board of Trustees of               *
 *                             the University of Illinois             *
 *                                                                    *
 *  This file is part of the RAPP software package, a library and     *
 *  associated programs for coordinating client/server applications.  *
 *                                                                    *
 **********************************************************************/

/* rapp_appd.h: Header file for RAPP application daemons.
 *
 * Rick Kufrin <r-kufrin@uiuc.edu>
 * National Center for Supercomputing Applications
 * May, 1995
 * 
 */

#ifndef _RAPP_APPD_H
#define _RAPP_APPD_H

#include <rapp.h>

/* Application daemon functions */

rapp_appd_handle_t
rapp_appd_setup(int , char **);

int
rapp_appd_init(rapp_appd_handle_t,
	       int (*)(rapp_appd_handle_t, rapp_paramlist_t *),
	       int (*)(rapp_active_socket_t *, void *),
	       int (*)(rapp_active_socket_t *, void *), void *);

#define rapp_appd_set_handler(handle, tag, func) \
        rapp_install_handler(&handle->handlers, tag, func)

int
rapp_appd_service_loop(rapp_appd_handle_t);

#define RAPP_APPD_SOCKET_NAME "/tmp/rapp_appd.%d"

#endif /* _RAPP_APPD_H */
