/**********************************************************************
 *         Copyright (C) 1995  The Board of Trustees of               *
 *                             the University of Illinois             *
 *                                                                    *
 *  This file is part of the RAPP software package, a library and     *
 *  associated programs for coordinating client/server applications.  *
 *                                                                    *
 **********************************************************************/

/* rapp_app.h: Header file for RAPP applications.
 *
 * Rick Kufrin <r-kufrin@uiuc.edu>
 * National Center for Supercomputing Applications
 * May, 1995
 * 
 */

#ifndef _RAPP_APP_H
#define _RAPP_APP_H

#include <rapp.h>

#ifdef __cplusplus
extern "C" {
#endif

rapp_app_handle_t rapp_app_setup(void);

int rapp_app_init(rapp_app_handle_t,
		  int (*)(rapp_active_socket_t *, void *),
		  int (*)(rapp_active_socket_t *, void *, void *),
		  void *, void *,
		  void (*)(void));

int rapp_app_update_client(rapp_app_handle_t, int);

int rapp_app_exit(rapp_app_handle_t);

#define rapp_app_set_handler(handle, tag, func) \
        rapp_install_handler(&handle->handlers, tag, func)

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* _RAPP_APP_H */
