/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: startup.h,v $
 *	$Author: billh $	$Locker:  $		$State: Exp $
 *	$Revision: 1.4 $	$Date: 1995/05/12 00:14:33 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 * Startup code for VMD ... used only by Global files, contains variables
 * and routines to read initial data files and scripts, and parse
 * command-line options.
 ***************************************************************************/
#ifndef STARTUP_VMD_H
#define STARTUP_VMD_H

/***************************************************************************
 enumerates for different initial status variables, such as the type of
 display to use at startup
 ***************************************************************************/

// display types at startup
enum DisplayTypes { DISPLAY_WIN, DISPLAY_CAVE, DISPLAY_TEXT, NUM_DISPLAY_TYPES};

// how to show the title
enum TitleTypes { TITLE_OFF, TITLE_ON, NUM_TITLE_TYPES };

/***************************************************************************
 string names for these enumerations
 ***************************************************************************/
extern char *displayTypeNames[];
extern char *titleTypeNames[];

/***************************************************************************
 initial status variables, used to control how VMD starts up
 ***************************************************************************/
extern int which_display;		  // type of display to use
extern float displayHeight, displayDist;  // height and distance of display
extern int displaySize[2], displayLoc[2]; // X,Y size and position of display
extern int showTitle;			  // how to show the title at start

/***************************************************************************
 function prototypes for startup routines
 ***************************************************************************/
extern void VMDgetEnvironment(void);
extern void VMDparseCommandLine(int, char **);
extern void VMDreadInit(void);
extern void VMDreadStartup(void);

#endif

/* REVISION HISTORY:********************************************************
 *
 * $Log: startup.h,v $
 * Revision 1.4  1995/05/12  00:14:33  billh
 * Moved log messages to end of file.
 *
 * Revision 1.3  95/04/04  21:05:41  billh
 * Added VMDTMPDIR env variable, and routine VMDgetEnvironment for
 * processing env variables.  Made global char string myTempDir to
 * hold a directory for temporary files, and routine VMDtempFile to
 * generate a temp filename from just a single string.
 * 
 * Revision 1.2  95/03/24  18:52:51  billh
 * Added copyright notice to top of file; made sure all virtual routines
 * are defined in the .C file, not in the .h file.
 * 
 * Revision 1.1  1995/01/09  08:54:17  billh
 * Initial revision
 *
 ***************************************************************************/
