/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: VRegion.h,v $
 *	$Author: billh $	$Locker:  $		$State: Exp $
 *	$Revision: 1.4 $	$Date: 1995/05/12 00:10:59 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *   A VRegion occupies a parallelpided of space (or all space) defined
 * by four of its corners.  If you give it a coordinate (as from the
 * tracker tip) it will see if:
 *  1) the coordinate just entered the region  (calls "entered")
 *  2) the coordinate just left the region  (calls "left", then "inside")
 *  3) the coordinate is still in the region (calls "inside")
 * The default representation is a box.
 *
 ***************************************************************************/
#ifndef VREGION_H
#define VREGION_H

#include "Displayable.h"
#include "Tracker.h"
#include "Scene.h"
#include "ToolControl.h"

// define regions of space which act in a "virtual" manner
// These are things like buttons, sliders, text boxes, and
// menus.  Things happen when a pointer enters a region,
// when a (tool) button is pressed, and when it leaves the region

class VRegion : public Displayable3D {
protected:         // various coordinates
  float corner[3];  // the upper left base corner of the region
  float v1[3], v2[3], v3[3]; // vectors that define the parallelpiped
  float uv1[3], uv2[3], uv3[3]; // unit vectors that define the parallelpiped
  float l1, l2, l3;  // the length of the parallelpiped for each dimension
  int uses_all_space; // for thingys that want to be everywhere
  
public:
  enum { OUTSIDE, INSIDE };
  // constructor is given the coordinates of the following corners:
  //  c1 = lower bottom left      c2 = upper bottom left
  //  c3 = upper bottom right     c4 = upper top left
  //   I hope you understand the directions :>
  //  These are then translated to the method used by the class 
  VRegion(float *c1, float *c2, float *c3, float *c4, char *name,
          Scene *sc, int memsize, int is_everywhere = FALSE);

  // destructor
  virtual ~VRegion(void);
  
  // given the pointer and tool of interest,
  //  find out if anything happened -- this calls most of the virtual
  //  functions except the motion ones
  // Returns TRUE if the coordinates are inside
  // Returns FALSE otherwise
  virtual int check_event(float *pos, ToolControl *toolctrl);

  // remake the command list
  void virtual redraw_list(int state);

  // this allows things to move around - remember to recreate the
  //   drawing lists after motion!
  // move (translate only) by some relative distance
  virtual void moveby(float *delta);
  // move to some absolute position
  virtual void moveto(float *newpos);


  // Call this function with the coordinate of interest.
  //  If the coordinate is inside the VRegion, it returns
  //    TRUE (FALSE if not).  This ensures that multiple
  //    VRegions don't get the same press
  //  It then called check_button with the appropriate information
  virtual int button_event(float *pos, ToolControl *toolctrl);

  // Called by button_event - it distills the above information
  // so that descended classes can handle the information
  // more selectively and simply
  virtual void check_button(int buttonnum, int change, 
                     float *delta, ToolControl *toolctrl);

private:
  int laststate;  // keep track for transitions
  // used for the default virtual functions
  char *name; // name used for the title, someday

protected:
  // note that delta is the distance from the corner, not the position
  //   in space!
  // called when a Tool just entered the region
  // arguments: distance of pointer from corner of VRegion, and ToolControl
  virtual void entered(float *, ToolControl *);

  // called while a Tool is inside - if it just entered, entered is
  //   called first, and then inside is called right after that
  // arguments: distance of pointer from corner of VRegion, and ToolControl
  virtual void inside(float *, ToolControl *);
  
  // called just after a Tool leaves the region
  virtual void left(void);

};

#endif

/* REVISION HISTORY:********************************************************
 *
 * $Log: VRegion.h,v $
 * Revision 1.4  1995/05/12  00:10:59  billh
 * Moved log messages to end of file.
 *
 * Revision 1.3  95/03/24  18:52:42  billh
 * Added copyright notice to top of file; made sure all virtual routines
 * are defined in the .C file, not in the .h file.
 * 
 * Revision 1.2  1994/11/09  05:04:37  billh
 * Moved VRegionList to a separate file.
 *
 * Revision 1.1  1994/09/26  07:15:16  dalke
 * Initial revision
 *
 ***************************************************************************/
