/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: VButton.h,v $
 *	$Author: billh $	$Locker:  $		$State: Exp $
 *	$Revision: 1.5 $	$Date: 1995/05/12 00:10:56 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *    A VButton is a VRegion that listens to a specific button and, when
 *  the button is pressed or unpressed, calls "execute".  In addition,
 *  if used in the "repeat" mode, it will call execute while the
 *  input coordinates stay within the region and the button is pressed.
 *
 ***************************************************************************/
#ifndef VBUTTON_H
#define VBUTTON_H

#include "VRegion.h"

enum {BUTTON0, BUTTON1, BUTTON2, BUTTON3, BUTTON4, BUTTON5, BUTTON6, BUTTON7,
      BUTTON8, BUTTON9, BUTTON10, BUTTON11, BUTTON12, BUTTON13, BUTTON14,
      BUTTON15, BUTTON16, BUTTON17 };  // 18 is good enough

// a VButton is a VRegion that listens to the button numbered 'button'.
// If that is pressed, it calls the execute function with the
// button state (down == is_pressed = TRUE)
//   'repeat' describes how the VButton calls execute.  You can have
// it call ONCE (when the button is pressed) REPEAT (keep calling when
// the button is pressed and stays inside the region) and ACTIVE (called
// whenever the location is in the region). Just remember that
// your 'execute', 'check_button' and 'left' must call this one after
// they finish, but your inside must not!
class VButton : public VRegion {
protected:
  int my_button;
  int do_repeats;
  int pressed;
public:
  enum {ONCE, REPEAT, ACTIVE };
  VButton(float *c1, float *c2, float *c3, float *c4, char *newname,
                 Scene *sc, int memsize,
                 int button, int repeat);
  virtual ~VButton(void);

  virtual void execute(int is_pressed);
  virtual void inside(float *delta, ToolControl *toolctrl) ;

  virtual void check_button(int buttonnum, int change, float *delta,
                              ToolControl *toolctrl) ;
  
  virtual void left(void) ;  // called when the pointer leaves the button
};


#ifdef VBUTTON_EXAMPLE
#include "CmdTrans.h"
// Here's a button which will rotate everything about an axis,
//   the axis is determined by the init. params.  The default axis
//   is the 'y' axis, 'cause that's what CmdRotate uses
class VButtonRotate : public VButton {
private:
  char axis;
  int angle;

public:
  VButtonRotate(float *c1, float *c2, float *c3, float *c4, char *newname,
                 Scene *sc, int memsize,
                 int button, int repeat, int rotby, char whichaxis)
        : VButton(c1, c2, c3, c4, newname, sc, memsize, button, repeat)
  {
   axis = whichaxis;
   angle = rotby;
  }

  virtual void execute(int);
};
#endif


#endif

/* REVISION HISTORY:********************************************************
 *
 * $Log: VButton.h,v $
 * Revision 1.5  1995/05/12  00:10:56  billh
 * Moved log messages to end of file.
 *
 * Revision 1.4  95/03/24  18:52:37  billh
 * Added copyright notice to top of file; made sure all virtual routines
 * are defined in the .C file, not in the .h file.
 * 
 * Revision 1.3  1994/10/04  21:36:04  dalke
 * Moved code to VButton.C, leaving only the prototypes
 *
 * Revision 1.2  1994/09/26  18:54:00  dalke
 * Added option for ACTIVE buttons (don't need button presses)
 *
 * Revision 1.1  1994/09/26  07:15:16  dalke
 * Initial revision
 *
 ***************************************************************************/
