/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: UIExternal.h,v $
 *	$Author: billh $	$Locker:  $		$State: Exp $
 *	$Revision: 1.3 $	$Date: 1995/05/12 00:10:50 $
 *
 ***************************************************************************
 * DESCRIPTION:
 * defines the interface to external UIs
 * for now we only allow input, and don't give output
 * and that input is straight text
 * This works via PVM, since that is easy to do
 * the information about max string size and the pvm message id 
 *    should be moved so others can use it.
 *
 ***************************************************************************/
#ifndef UIEXTERNAL_H
#define UIEXTERNAL_H

#include "UIObject.h"

#define EXTERNALD_MAXSTRLEN 200
#define EXTERNAL_TEXTEVENT 8000


class UIExternal : public UIObject {

private:
  // is >0 if all okay, ==0 if PVM wasn't (or could not) started
  int myid;
  static int uniqid;   // uniq id for the above

  int ison;

  static int pvmcount; // how many instances of pvm are there?
  void leave_pvm(void); // stop listening and, maybe, detach from PVM

public:
  UIExternal(UIList *, CommandQueue *);  // constructor
  virtual ~UIExternal(void);
  
  // check for a new string and queue it if found.  
  // Returns TRUE if an event was generated.  
  virtual int check_event(void);

  int start_listening(void);
  int stop_listening(void);
};

#endif // UIEXTERNAL_H

/* REVISION HISTORY:********************************************************
 *
 * $Log: UIExternal.h,v $
 * Revision 1.3  1995/05/12  00:10:50  billh
 * Moved log messages to end of file.
 *
 * Revision 1.2  95/03/24  18:52:19  billh
 * Added copyright notice to top of file; made sure all virtual routines
 * are defined in the .C file, not in the .h file.
 * 
 * Revision 1.1  1995/02/22  08:55:55  dalke
 * Initial revision
 *
 ***************************************************************************/
