/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: UIExternal.C,v $
 *	$Author: billh $	$Locker:  $		$State: Exp $
 *	$Revision: 1.4 $	$Date: 1995/05/12 00:10:44 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *  This provides a very simple interface by which external commands
 * may be entered into vmd as if they were text commands.  This
 * interface uses PVM for the communications, because that's what
 * I know how to use.
 *
 ***************************************************************************/

#include "UIExternal.h"
#include "UIText.h"
#include "CmdExternal.h"
#include "Inform.h"

// currently this uses PVM for communication
#include <pvm3.h>


const int numCmds = 0; // someday maybe I'll listen??
static int cmdList[] = {Command::EXTERNAL_START,
		         Command::EXTERNAL_END};

// static member initialization
int UIExternal::pvmcount = 0;
int UIExternal::uniqid = 0;


//////////////////////////// constructor
UIExternal::UIExternal(UIList *uil, CommandQueue *cq)
	: UIObject("External Interface", uil, cq) {
   myid = ++uniqid;
   MSGDEBUG(1, "Started External interface " << myid << " ..." << sendmsg);
   for (int i=0; i<numCmds; i++)
     command_wanted(cmdList[i]);
   ison = FALSE;
}

//////////////////////////// destructor
UIExternal::~UIExternal(void)
{
   MSGDEBUG(1, "Stopped External interface " << myid << " ..." << sendmsg);
   if (ison) {
      leave_pvm();
   }
}

  
// if I'm listening for external PVM commands,
// see if I got one, and put it on the queue
int UIExternal::check_event(void)
{
   int bufid;
   if (ison) {
      if ((bufid = pvm_nrecv(-1, EXTERNAL_TEXTEVENT)) > 0) { // probe for msg
	 char newstr[EXTERNALD_MAXSTRLEN+1];
	 int info = pvm_upkstr( newstr);                     // get the string
	 if (info == 0) {
	     // and enque it
	    addcommand(new TextEvent(stringdup(newstr), TRUE, id()));
	    return TRUE;
	 } else {
	    msgErr << "Problem with unpacking an external message" << sendmsg;
	 }
      }
   }
   return FALSE;
}


// either start or end checking for external functions
int UIExternal::start_listening(void)
{
   if (ison) {
      msgWarn << "External PVM interface already turned on" << sendmsg;
      return TRUE;
   }
   int temptid = pvm_mytid(); // starts up pvm
   if (temptid < 0) {
      msgErr<<"PVM had not been started, or could not be found." << sendmsg;
      msgErr << "I will not try to start it up myself." << sendmsg;
      return FALSE;
   } else {
      pvmcount++;
      if ( pvm_joingroup("vmd") < 0) {
 msgErr << "Try starting the group server, $HOME/pvm3/lib/$ARCH/pvmgs.";
 msgErr << sendmsg;
 msgErr << "You may want to: ln -s $HOME/pvm3/lib/$ARCH/pvmgs ";
 msgErr << "$HOME/pvm3/bin/$ARCH/" << sendmsg;
         leave_pvm();
	 return FALSE;
      }
      msgInfo << "External PVM interface " << myid << " on" << sendmsg;
      ison = TRUE;
      return TRUE;
   }
}

// detach from the pvm 
int UIExternal::stop_listening(void)
{
   if (!ison) {  // doesn't try to force a withdraw from PVM
      msgErr << "External PVM interface " << myid << " not on" << sendmsg;
      return FALSE;
   }
   leave_pvm();
   return TRUE;
}


// stop listening to pvm
// if there are no other UIExternals running, remove myself from
// the PVM
void UIExternal::leave_pvm(void)
{
   if (pvmcount <=0 ) {
      msgErr << "Too many attempts to leave PVM" << sendmsg;
      pvmcount=1;
   }
   pvmcount--;
   ison = FALSE;
   msgErr << "External interface " << myid << " leaving PVM" << sendmsg;
   if (pvmcount ==0 ) {
      if (pvm_exit() < 0 ) {
	 msgErr << "Could not contact PVM to disconnect???" << sendmsg;
      } else {
	 msgInfo << "All External interfaces removed from PVM" << sendmsg;
      }
   } else {
      msgInfo << pvmcount << " External interfaces remain" << sendmsg;
   }
}

/* REVISION HISTORY:********************************************************
 *
 * $Log: UIExternal.C,v $
 * Revision 1.4  1995/05/12  00:10:44  billh
 * Moved log messages to end of file.
 *
 * Revision 1.3  95/04/04  21:51:16  dalke
 * fixed usage of TextEvent
 * 
 * Revision 1.2  1995/03/24  18:52:17  billh
 * Added copyright notice to top of file; made sure all virtual routines
 * are defined in the .C file, not in the .h file.
 *
 * Revision 1.1  1995/02/22  08:55:55  dalke
 * Initial revision
 *
 ***************************************************************************/
