/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *      $RCSfile: TrackerList.h,v $
 *      $Author: billh $        $Locker:  $                $State: Exp $
 *      $Revision: 1.6 $      $Date: 1995/05/11 23:46:25 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *   Maintain a list of trackers.  Trackers can only be added to the list!
 *
 ***************************************************************************/
#ifndef TRACKERLIST_H
#define TRACKERLIST_H

#include "Tracker.h"
#include "ResizeArray.h"


class TrackerList {
public:
  // list of trackers which can be started
typedef struct AvailTrackertypestruct {
  char *visiblename; // name the user sees
  int numsensors;    // number of sensors to use
  char *UNCname;     // name like 'fastrak1' or 'boom2'
} AvailTrackertype;

  // data type for trackers in operation
typedef struct TrackerListtypestruct {
  Tracker *tracker;
  char *name;     // the UNCname+(remotename) the user sees; is unique !!
} TrackerListtype;

private:
  ResizeArray<TrackerListtype *> trackerList;
  ResizeArray<AvailTrackertype *> availList;
  
public:
  TrackerList( void);  // constructor
  ~TrackerList( void); // destructor

  int check_event( void);
/***** Interaction with the AvailTracker structure ****/
public:
    // make "visiblename" be associated with a UNC call
void add_avail(char *visible, char *UNCname,
       int numsensors);

    // return the number of AvailTracker available
int num_avail(void );
    // return the name associated with the AvailTracker
const char *avail_name(int availid);

    // Start up the AvailTracker
    //  on success, it returns TRACKER_OK
    //  anything else is an error (like if you attempt to
    //  start two UNC names on the same machine.)
int start_avail(int availid, char *remotemachine=NULL);

private:
    // Given the index, return the pointer to the right element
AvailTrackertype *avail_list_ptr(int availid);

/*******  Now to maintain the TrackerList information **/
public:
     // return the number of Trackers
 int num();
     // Here is how to create a Tracker and bypass the Avail stuff
 void add(Tracker *newtracker, char *uniquename);

     // returns the pointer to the list element which contains the
     // tracker pointer and its name (though you should use "tracker"
     // and "trackerName" for the same purposes)
 TrackerListtype *TrackerList::list_ptr(int trackerid);

     // returns the name for the Tracker
 char *name(int trackerid);

    // return the n-th tracker on the linked list (or NULL)
Tracker *tracker(int trackerid);
    // return the index of the Tracker (or returns TRACKER_NOK)
int find_index(Tracker *tracker);


private:
    //  Only one instance of a tracker is allowed on a machine.  To
    //  check this, I'm given the UNCname+machine name, and I compare
    //  this to the list of running trackers
    //  returns FALSE if a match was found
 int name_is_unique(char *fullname);
};

#endif

/* REVISION HISTORY:********************************************************
 *
 * $Log: TrackerList.h,v $
 * Revision 1.6  1995/05/11  23:46:25  billh
 * Updated due to changes in Buttons; moved log message to end of file.
 *
 * Revision 1.5  95/03/24  18:52:15  billh
 * Added copyright notice to top of file; made sure all virtual routines
 * are defined in the .C file, not in the .h file.
 * 
 * Revision 1.4  1994/10/05  06:56:30  dalke
 * Changed from DLinkList to ResizeArray
 *
 * Revision 1.3  1994/09/17  09:42:35  dalke
 * Took TrackerList out of UIList and into UIVR.
 * Added code to start_avail to associate sensors with "buttons"
 *
 * Revision 1.2  1994/09/07  07:48:31  dalke
 * various name changes, made TrackerList part of UIObject class,
 * and more - still writing
 *
 * Revision 1.1  1994/09/03  11:19:09  dalke
 * Initial revision
 *
 ***************************************************************************/
