/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: Tool.C,v $
 *	$Author: billh $	$Locker:  $		$State: Exp $
 *	$Revision: 1.7 $	$Date: 1995/05/11 23:45:54 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *  Code for Tool base class.  Does the things like draw an arrow,
 *   and check for the VButtons.  Also, this sets up the transformations
 *   needed to convert the tracker/sensor tip to the molecular coordinate
 *   system
 *
 ***************************************************************************/

#include "Tool.h"
#include "ColorList.h"
#include "UIVR.h"
#include "Global.h"


Tool::Tool(char *name, Scene *sc, int size) 
    : Displayable3D(LOAD, name, sc, size)
  {
      rot_off();  // don't listen to anyone else's transformations
      scale_off();
      glob_trans_off();
      cent_trans_off();
      tip_checking = FULL;
      needRegenerate = TRUE;
  }
 
//////////////////////////////////  protected routines

// default is to draw a simple pointer - a line
void Tool::redraw_list(ToolInfo *) {
  // base class has none
}


// call the VRegions with the tip information
void Tool::check_VRegions(float *pos, ToolControl *toolctrl) {
  uiVR -> vregions -> check_event(pos, toolctrl);
}


 //   set up the current graphics rotation matrix
 //   (and save it into the variable "Matrix4 rotataion") and
 //  set the current graphics translation so the _base_ is at
 //   the center(0,0,0)
 //  compute the coordinate of the tip, given the length
void Tool::do_graphics_transformation(ToolInfo *info) {
  Matrix4 rotation;  // for turning tracker/sensor info to matrix form
  Matrix4 scaling;
  for (int i=0; i<3; i++)   // set up the orientation matrix
    for (int j=0; j<3; j++)
      rotation.mat[i][j] = info -> orient[i*3+j];
  for (i=0; i<3; i++)
    rotation.mat[i][3] = rotation.mat[3][i] = 0;
  rotation.mat[3][3] = 1;
  
  rot_on();
   set_rot(rotation);
  rot_off();

  scaling.scale(info -> length, info -> radius, info -> radius);
  scale_on();
   set_scale(scaling);  // apply new scaling
  scale_off();
  
  glob_trans_on();     // do the translation
   set_glob_trans(info -> base[0], info -> base[1], info -> base[2]);
  glob_trans_off();
  
  // now that the matrices are set, compute the tip coordinates
  info -> tip[0] = info -> length;
  info -> tip[1] = info -> tip[2] = 0.0;
  tm.multpoint3d(info -> tip, info -> tip);
}


//////////////////////////  public routines

  // this is the first thing called by the above.  It lets the
  // Tool override anything coming in
void Tool::tool_event(ToolControl *, ToolInfo *) {
  // default version does nothing
}
  

  // this is the mechanism by which extensions to the basic tool is made
  // All you do is send the string to the Tool
void Tool::tell(char *) {
  // default version does nothing
}


 // this is called by ToolControl for updating
 //   set up the current graphics rotation matrix
 //   (and save it into the variable "Matrix4 rotataion") and
 //  set the current graphics translation so the _base_ is at
 //   the center(0,0,0)
void Tool::check_event(ToolControl *toolctrl, ToolInfo *info) {
   // let the tool override whatever it wants
 tool_event(toolctrl, info);  // this is for functions that want to be
                              // called every time.
 
   // setup to the proper viewpoint
 do_graphics_transformation(info);
 if (needRegenerate) {
   redraw_list(info);  //make the drawing list
 }

 //  if tip_checking is enabled, then check all the VRegions for
 // button presses caused by the tip of the pointer
 if (tip_checking != NONE)
   check_VRegions(info -> tip, toolctrl);
}

  // this is called whenever a button changes state
  // this default action sends all button info to all VRegions
void Tool::button_event(ToolControl *toolctrl, ToolInfo *info) {
  if (tip_checking == FULL)
   uiVR -> vregions -> button_event(info -> tip, toolctrl);
}

/* REVISION HISTORY:********************************************************
 *
 * $Log: Tool.C,v $
 * Revision 1.7  1995/05/11  23:45:54  billh
 * Updated due to changes in Buttons; moved log message to end of file.
 *
 * Revision 1.6  95/03/24  18:52:03  billh
 * Added copyright notice to top of file; made sure all virtual routines
 * are defined in the .C file, not in the .h file.
 * 
 * Revision 1.5  1994/10/04  20:29:22  billh
 * Changes to get to compile on HP's ... not there yet,though.
 *
 * Revision 1.4  1994/10/04  09:04:00  dalke
 * Added needRegenerate (instead of 'detail')
 * moved check_event to here from .h
 *
 * Revision 1.3  1994/10/03  08:34:10  dalke
 * changed resolution to detail
 * replaced "firstdraw" with an "int detail" so the tool would
 *   redraw every time the info->detail changes
 * fixed the scaling problem
 *
 * Revision 1.2  1994/10/02  10:57:15  dalke
 *   Added unique id for each ToolControl
 *   Move graphical representation to SimpleTool.  None in the base class.
 *
 * Revision 1.1  1994/09/26  07:15:16  dalke
 * Initial revision
 *
 ***************************************************************************/
