/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: Tokenize.C,v $
 *	$Author: billh $	$Locker:  $		$State: Exp $
 *	$Revision: 1.4 $	$Date: 1995/05/11 23:57:14 $
 *
 ***************************************************************************
 * DESCRIPTION:
 * Simple tokenizing class
 * given a string, makes an array of all the tokens needed
 *
 ***************************************************************************/

#include "Tokenize.h"
#include "utilities.h"
#include <string.h>

Tokenize::Tokenize(char *data, char *delimiters) :
   tokens(20)
{
    datastr = stringdup(data);
    char *s;
    for (s=strtok(datastr, delimiters);
         s;
         s=strtok(NULL, delimiters) ) {
         
         tokens.append(s);
    }
  }
  
Tokenize::~Tokenize(void) {
    delete [] datastr;
  }

/* REVISION HISTORY:********************************************************
 *
 * $Log: Tokenize.C,v $
 * Revision 1.4  1995/05/11  23:57:14  billh
 * Moved log messages to end of file.
 *
 * Revision 1.3  95/03/24  18:52:00  billh
 * Added copyright notice to top of file; made sure all virtual routines
 * are defined in the .C file, not in the .h file.
 * 
 * Revision 1.2  1994/11/21  23:30:46  billh
 * Added include of string.h header.
 *
 * Revision 1.1  1994/11/12  10:23:51  dalke
 * Initial revision
 *
 ***************************************************************************/

