/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: Timer.h,v $
 *	$Author: billh $	$Locker:  $		$State: Exp $
 *	$Revision: 1.3 $	$Date: 1995/05/11 23:57:11 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *      The Timer class allows for easy timing of the program.  The timer
 * tracks real (clock) time elapsed, user time, and system time.
 *
 ***************************************************************************/
#ifndef TIMER_H
#define TIMER_H

class Timer
{
private:
	short timer_state;		// State of timer, either on or off
	long cpu_speed;			// CPU speed for times() call

	unsigned long last_secs;	// Clock seconds value when the
					// timer was last started
	long last_usecs;		// Clock useconds value when the
					// timer was lat started
	unsigned long last_user_time;   // User time when timer was last
					// started
	unsigned long last_system_time; // System time when timer was last
					// started

	long current_secs;		// Current accumulated clock seconds
	long current_usecs;		// Current accumulated clock useconds
	long current_user_time;		// Current accumulated user time
	long current_system_time;	// Current accumulated user time

public:
	Timer();			// Constuctor

	void clear();			// Set all accumulated times to 0
	void start();			// Start timer
	void stop();			// Stop timer
	void reset();			// clear and, if started, restart
	float clock_time();		// Report clock time accumulated
					// in seconds
	float user_time();		// Report user time accumlated
					// in seconds
	float system_time();		// Report system time accumulated in
					// seconds
	float cpu_time() {return(user_time()+system_time());}		
					// Report total cpu_time which is
					// just user_time+system_time
};

#endif

/* REVISION HISTORY:********************************************************
 *
 * $Log: Timer.h,v $
 * Revision 1.3  1995/05/11  23:57:11  billh
 * Moved log messages to end of file.
 *
 * Revision 1.2  95/03/24  18:51:56  billh
 * Added copyright notice to top of file; made sure all virtual routines
 * are defined in the .C file, not in the .h file.
 * 
 * Revision 1.1  1994/10/12  08:37:52  dalke
 * Initial revision
 *
 ***************************************************************************/
