/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: Stack.h,v $
 *	$Author: billh $	$Locker:  $		$State: Exp $
 *	$Revision: 1.4 $	$Date: 1995/05/11 23:57:07 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 * Stack template
 *
 ***************************************************************************/
#ifndef STACK_TEMPLATE_H
#define STACK_TEMPLATE_H


template<class T>
class Stack {

private:
  // list of items, and pointer to current item
  T *data, *curr;

  // number of items, and items currently on stack
  int sz, items;
  
public:
  // constructor/destructor
  Stack(int s);
  ~Stack(void);

  //
  // query status of this class
  //
  
  // return maximum, and current, size of stack
  int max_stack_size(void) { return sz; }
  int stack_size(void) { return items; }
  int num(void) { return items; }

  //
  // routine to manipulate the stack
  //

  // push a new item onto the stack.
  Stack<T>& push(const T&);
  
  // push the stack, making a copy of the top element
  Stack<T>& push(void);
  
  // pop the stack
  T& pop(void);
  
  // return reference to top item, but do not pop the stack
  T& top(void);

};

#endif

/* REVISION HISTORY:********************************************************
 *
 * $Log: Stack.h,v $
 * Revision 1.4  1995/05/11  23:57:07  billh
 * Moved log messages to end of file.
 *
 * Revision 1.3  95/03/24  18:51:50  billh
 * Added copyright notice to top of file; made sure all virtual routines
 * are defined in the .C file, not in the .h file.
 * 
 * Revision 1.2  1995/01/29  19:57:16  billh
 * Moved almost all in-lined functions to .c file
 *
 * Revision 1.1  94/08/24  03:10:37  billh
 * Initial revision
 * 
 ***************************************************************************/
