/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: PickModeQuery.C,v $
 *	$Author: billh $	$Locker:  $		$State: Exp $
 *	$Revision: 1.3 $	$Date: 1995/05/11 23:31:25 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 * PickModeQuery is a special PickMode which just queries what kind of
 * object the item picked is.  If the mouse is pressed and released without
 * any movement, the name of the Displayable is simply printed to the console.
 *
 ***************************************************************************/

#include <math.h>
#include <string.h>
#include "PickModeQuery.h"
#include "Pickable.h"
#include "DisplayDevice.h"
#include "Inform.h"


//////////////////////////// constructor  ////////////////////////////
PickModeQuery::PickModeQuery(void) {
  pQuery = NULL;
  needName = FALSE;
}


///////////////////// public virtual routines  ////////////////////////

// called when a pick is begun:
//	args = display to use, obj picked, button, tag, dim, pos
// For 2D version: x & y are 0 ... 1, represent 'relative, scaled' coords.
// For 3D version: x,y,z are transformed position of pointer
// Here, who cares what the button was
void PickModeQuery::pick_start(DisplayDevice *,
			Pickable *p, int, int, int dim, float *pos) {
  pQuery = p;
  memcpy((void *)pPos, (void *)pos, dim*sizeof(float));
  needName = (p != NULL);
}

  
// called when a pick moves:
//	args = display to use, obj picked, button, tag, dim, pos
// For 2D version: x & y are 0 ... 1, represent 'relative, scaled' coords.
// For 3D version: x,y,z are transformed position of pointer
// Here, who cares what the button was
void PickModeQuery::pick_move(DisplayDevice *,
			Pickable *p, int, int, int dim, float *pos) {
  if(needName) {
    float mvdist = 0.0;
    for(int i=0; i < dim; i++)
      mvdist += fabs(pPos[i] - pos[i]);
    if(mvdist > 0.02 || p != pQuery)
      needName = FALSE;
  }
}


// called when a pick ends:
//	args = display to use, obj picked, button, tag, dim, pos
// For 2D version: x & y are 0 ... 1, represent 'relative, scaled' coords.
// For 3D version: x,y,z are transformed position of pointer
// Here, who cares what the button was
void PickModeQuery::pick_end(DisplayDevice *,
			Pickable *p, int, int, int, float *) {
  if(p == pQuery && needName) {
    msgInfo << "Selected item: " << pQuery->pick_name() << sendmsg;
  }
  pQuery = NULL;
  needName = FALSE;
}

/* REVISION HISTORY:********************************************************
 *
 * $Log: PickModeQuery.C,v $
 * Revision 1.3  1995/05/11  23:31:25  billh
 * Moved log messages to end of file.
 *
 * Revision 1.2  95/03/24  18:51:13  billh
 * Added copyright notice to top of file; made sure all virtual routines
 * are defined in the .C file, not in the .h file.
 * 
 * Revision 1.1  1995/02/22  03:56:04  billh
 * Initial revision
 *
 ***************************************************************************/
