/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: MoleculeSigma.h,v $
 *	$Author: billh $	$Locker:  $		$State: Exp $
 *	$Revision: 1.2 $	$Date: 1995/05/11 23:08:24 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 * A MoleculeSigma is inherited from MoleculeFile, and supplies additional
 * routines to link the Molecule with the SIgMA MD code.
 *
 ***************************************************************************/
#ifndef MOLECULESIGMA_H
#define MOLECULESIGMA_H

#include "MoleculeFilePSF.h"


class MoleculeSigma : public MoleculeFilePSF {

public:

private:
  void init_sigma();
  void connect();
  void disconnect();

  // File descriptor of socket to Sigma
  int	sock;

  // Pick mode generated for dragging
  static int pickDragMode;

protected:

  // read menu definition from Sigma
  void read_menu(char *);

  // read coordinates from Sigma
  void read_coords(char *);

public:
  //  class constructor/destructor
  MoleculeSigma(char *, Scene *);
  MoleculeSigma(char *, Displayable *);
  virtual ~MoleculeSigma(void);

  // creates the molecule, using the info provided in the constructor.
  // returns success, and also calls parent class create routines
  virtual int create(void);

  // prepare for drawing ... do any updates needed right before draw.
  // This possibly reads a new timestep, if requested.
  virtual void prepare(DisplayDevice *);

  // Pickable overrides, for adding restraints

  // return if we are interested in the given pick mode or not
  virtual int want_pick_mode(int);
  PickMode *create_pick_mode(int);

  // called when a pick is begun:
  //	args = display to use, obj picked, button, mode, tag, dim, pos
  // For 2D version: x & y are 0 ... 1, represent 'relative, scaled' coords.
  // For 3D version: x,y,z are transformed position of pointer
  virtual void pick_start(DisplayDevice *, Pickable *,
				int, int, int, int, float *);

  // called when a pick moves:
  //	args = display to use, obj picked, button, mode, tag, dim, pos
  // For 2D version: x & y are 0 ... 1, represent 'relative, scaled' coords.
  // For 3D version: x,y,z are transformed position of pointer
  virtual void pick_move(DisplayDevice *, Pickable *,
				int, int, int, int, float *);

  // called when a pick ends:
  //	args = display to use, obj picked, button, mode, tag, dim, pos
  // For 2D version: x & y are 0 ... 1, represent 'relative, scaled' coords.
  // For 3D version: x,y,z are transformed position of pointer
  virtual void pick_end(DisplayDevice *, Pickable *,
				int, int, int, int, float *);

};

#endif

/* REVISION HISTORY:********************************************************
 *
 * $Log: MoleculeSigma.h,v $
 * Revision 1.2  1995/05/11  23:08:24  billh
 * Moved log message to the end of the file.
 * Updated to use new mouse menu addition routines.
 *
 * Revision 1.1  95/04/05  20:45:59  billh
 * Initial revision
 * 
 ***************************************************************************/
