/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: MoleculeFile.h,v $
 *	$Author: billh $	$Locker:  $		$State: Exp $
 *	$Revision: 1.7 $	$Date: 1995/05/11 23:18:09 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 * A MoleculeFile is inherited from Molecule, and supplies routines to 
 * create a molecule by reading data from a file.
 *
 ***************************************************************************/
#ifndef MOLECULEFILE_H
#define MOLECULEFILE_H

#include "Molecule.h"


class MoleculeFile : public Molecule {

public:
  // ways to read structure ... character names are in the array declared
  // at the bottom of this file.
  enum StructureFile { PSF, PDB, EDM, GRAPH, RASTER3D,
     T, PREP, BS, CAR, BOOG, CACCRT, CADPAC, CHARMM, C3D1, C3D2, CSSR, 
     FDAT, C, FEAT, F, GAMOUT, G, GAUOUT, HIN, ISIS, MACMOL, K, MICRO, 
     MI, MO, MM3, MMADS, MDL, MOLEN, AC, AI, AO, PC, QUANTA, SHELX, 
     SPAR, SEMI, SPMM, MOL, MOL2, CON, MACCS2, MACCS3, UNIXYZ, X, XED, 
		       STRTYPES, UNKNOWN };

protected:
  // name of path and filename containing structure of molecule
  char *strFile, *strPath, *strName;

  // this extracts the filename
  // and inits some data
  void do_construct(char *filename);

public:
  //  class constructor/destructor
  MoleculeFile(char *filename, Scene *);
  MoleculeFile(char *filename, Displayable *);
  virtual ~MoleculeFile(void);

  // creates the molecule, using the info provided in the constructor.
  // returns success, and also calls parent class create routines
  virtual int create(void);

  // return the path and name of this molecule
  virtual char *file_path(void);
  virtual char *file_name(void);

};

// string names for the different structure file types (identified by
// their file extension)
extern char *structureFileTypeNames[MoleculeFile::STRTYPES];

#endif

/* REVISION HISTORY:********************************************************
 *
 * $Log: MoleculeFile.h,v $
 * Revision 1.7  1995/05/11  23:18:09  billh
 * Moved log messages to end of file.
 *
 * Revision 1.6  95/04/05  21:42:47  dalke
 * Added interface to Babel for file conversion to PDB
 * 
 * Revision 1.5  1995/03/24  18:50:38  billh
 * Added copyright notice to top of file; made sure all virtual routines
 * are defined in the .C file, not in the .h file.
 *
 * Revision 1.4  1995/02/12  07:21:11  dalke
 * moved PDB and PSF reads into seperate objects, making a "Molecule"
 * be much more general.
 *
 * Revision 1.3  1994/11/22  02:35:19  billh
 * Changed to not require StructureFile enum as type of argument to constructor.
 *
 * Revision 1.2  94/09/30  05:36:18  billh
 * Added externally-available string arrays for file type extensions.
 * 
 * Revision 1.1  1994/09/17  09:11:36  billh
 * Initial revision
 *
 ***************************************************************************/
